/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.transport.http.asyncclient.CXFHttpRequest;
import org.apache.cxf.transport.http.asyncclient.SharedOutputBuffer;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

public class CXFHttpAsyncRequestProducer
implements HttpAsyncRequestProducer {
    private final CXFHttpRequest request;
    private final SharedOutputBuffer buf;
    private volatile CachedOutputStream content;
    private volatile ByteBuffer buffer;
    private volatile InputStream fis;
    private volatile ReadableByteChannel chan;

    public CXFHttpAsyncRequestProducer(CXFHttpRequest request, SharedOutputBuffer buf) {
        this.buf = buf;
        this.request = request;
    }

    public HttpHost getTarget() {
        URI uri = this.request.getURI();
        if (uri == null) {
            throw new IllegalStateException("Request URI is null");
        }
        if (!uri.isAbsolute()) {
            throw new IllegalStateException("Request URI is not absolute");
        }
        int i = uri.getPort();
        if (i == -1) {
            i = 80;
        }
        return new HttpHost(uri.getHost(), i, uri.getScheme());
    }

    public HttpRequest generateRequest() throws IOException, HttpException {
        return this.request;
    }

    public void produceContent(ContentEncoder enc, IOControl ioc) throws IOException {
        if (this.content != null) {
            if (this.buffer == null) {
                if (this.content.getTempFile() == null) {
                    this.buffer = ByteBuffer.wrap(this.content.getBytes());
                } else {
                    this.fis = this.content.getInputStream();
                    this.chan = this.fis instanceof FileInputStream ? ((FileInputStream)this.fis).getChannel() : Channels.newChannel(this.fis);
                    this.buffer = ByteBuffer.allocate(8192);
                }
            }
            int i = -1;
            this.buffer.rewind();
            if (this.buffer.hasRemaining() && this.chan != null) {
                i = this.chan.read(this.buffer);
                this.buffer.flip();
            }
            enc.write(this.buffer);
            if (!this.buffer.hasRemaining() && i == -1) {
                enc.complete();
            }
        } else {
            this.buf.produceContent(enc, ioc);
        }
    }

    public void requestCompleted(HttpContext context) {
        if (this.fis != null) {
            try {
                this.fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.chan = null;
            this.fis = null;
        }
        this.buffer = null;
    }

    public void failed(Exception ex) {
        this.buf.shutdown();
    }

    public boolean isRepeatable() {
        return this.request.getOutputStream().retransmitable();
    }

    public void resetRequest() throws IOException {
        if (this.request.getOutputStream().retransmitable()) {
            this.content = this.request.getOutputStream().getCachedStream();
        }
    }

    public void close() throws IOException {
        this.buf.close();
        if (this.fis != null) {
            try {
                this.fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.chan = null;
            this.fis = null;
        }
        this.buffer = null;
    }
}

