/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.util.NameUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.WSDLToJavaProcessor;

public class AntGenerator
extends AbstractJAXWSGenerator {
    private static final String ANT_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/build.vm";

    public AntGenerator() {
        this.name = "ant.generator";
    }

    @Override
    public boolean passthrough() {
        return !this.env.optionSet("ant") && !this.env.optionSet("all") && !this.env.optionSet("genAnt");
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        if (this.passthrough()) {
            return;
        }
        Map map = CastUtils.cast((Map)penv.get(WSDLToJavaProcessor.MODEL_MAP));
        for (JavaModel javaModel : map.values()) {
            if (javaModel.getServiceClasses().size() == 0) {
                ServiceInfo serviceInfo = this.env.get(ServiceInfo.class);
                String wsdl = serviceInfo.getDescription().getBaseURI();
                Message msg = new Message("CAN_NOT_GEN_ANT", LOG, wsdl);
                if (penv.isVerbose()) {
                    System.out.println(msg.toString());
                }
                return;
            }
            HashMap<String, String> clientClassNamesMap = new HashMap<String, String>();
            HashMap<String, String> serverClassNamesMap = new HashMap<String, String>();
            Map<String, JavaInterface> interfaces = javaModel.getInterfaces();
            int index = 1;
            for (JavaServiceClass js : javaModel.getServiceClasses().values()) {
                for (JavaPort jp : js.getPorts()) {
                    String interfaceName = jp.getInterfaceClass();
                    JavaInterface intf = interfaces.get(interfaceName);
                    if (intf == null) {
                        interfaceName = jp.getPortType();
                        intf = interfaces.get(interfaceName);
                    }
                    String clientClassName = intf.getPackageName() + "." + interfaceName + "_" + NameUtil.mangleNameToClassName(jp.getPortName()) + "_Client";
                    String serverClassName = intf.getPackageName() + "." + interfaceName + "_" + NameUtil.mangleNameToClassName(jp.getPortName()) + "_Server";
                    String clientTargetName = interfaceName + "Client";
                    boolean collison = false;
                    if (clientClassNamesMap.keySet().contains(clientTargetName)) {
                        clientTargetName = clientTargetName + index;
                        collison = true;
                    }
                    String serverTargetName = interfaceName + "Server";
                    if (serverClassNamesMap.keySet().contains(serverTargetName)) {
                        serverTargetName = serverTargetName + index;
                        collison = true;
                    }
                    if (collison) {
                        ++index;
                    }
                    clientClassNamesMap.put(clientTargetName, clientClassName);
                    serverClassNamesMap.put(serverTargetName, serverClassName);
                }
            }
            this.clearAttributes();
            this.setAttributes("clientClassNamesMap", clientClassNamesMap);
            this.setAttributes("serverClassNamesMap", serverClassNamesMap);
            this.setAttributes("wsdlLocation", javaModel.getLocation());
            this.setCommonAttributes();
            this.doWrite(ANT_TEMPLATE, this.parseOutputName(null, "build", ".xml"));
        }
    }
}

