/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JAXBUtils {
    private JAXBUtils() {
    }

    private static Node innerJaxbBinding(Element schema) {
        String schemaNamespace = schema.getNamespaceURI();
        List<Element> annoList = DOMUtils.findAllElementsByTagNameNS(schema, schemaNamespace, "annotation");
        Element annotation = null;
        annotation = annoList.size() > 0 ? annoList.get(0) : schema.getOwnerDocument().createElementNS(schemaNamespace, "annotation");
        List<Element> appList = DOMUtils.findAllElementsByTagNameNS(annotation, schemaNamespace, "appinfo");
        Element appInfo = null;
        if (appList.size() > 0) {
            appInfo = appList.get(0);
        } else {
            appInfo = schema.getOwnerDocument().createElementNS(schemaNamespace, "appinfo");
            annotation.appendChild(appInfo);
        }
        Element jaxbBindings = null;
        List<Element> jaxbList = DOMUtils.findAllElementsByTagNameNS(schema, "http://java.sun.com/xml/ns/jaxb", "schemaBindings");
        if (jaxbList.size() > 0) {
            jaxbBindings = jaxbList.get(0);
        } else {
            jaxbBindings = schema.getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/jaxb", "schemaBindings");
            appInfo.appendChild(jaxbBindings);
        }
        return jaxbBindings;
    }

    public static Node innerJaxbPackageBinding(Element schema, String packagevalue) {
        Document doc = schema.getOwnerDocument();
        if (!XMLUtils.hasAttribute(schema, "http://java.sun.com/xml/ns/jaxb")) {
            Attr attr = schema.getOwnerDocument().createAttributeNS("http://java.sun.com/xml/ns/jaxb", "version");
            attr.setValue("2.0");
            schema.setAttributeNodeNS(attr);
        }
        Node schemaBindings = JAXBUtils.innerJaxbBinding(schema);
        List<Element> pkgList = DOMUtils.findAllElementsByTagNameNS(schema, "http://java.sun.com/xml/ns/jaxb", "package");
        Element packagename = null;
        packagename = pkgList.size() > 0 ? pkgList.get(0) : doc.createElementNS("http://java.sun.com/xml/ns/jaxb", "package");
        packagename.setAttributeNS(null, "name", packagevalue);
        schemaBindings.appendChild(packagename);
        return schemaBindings.getParentNode().getParentNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPackageMappingSchemaBindingFile(String namespace, String pkgName) {
        Document doc = DOMUtils.createDocument();
        Element rootElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2001/XMLSchema");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
        rootElement.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:version", "2.0");
        rootElement.setAttributeNS(null, "targetNamespace", namespace);
        Element annoElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        Element appInfo = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
        Element schemaBindings = doc.createElementNS("http://java.sun.com/xml/ns/jaxb", "jaxb:schemaBindings");
        Element pkgElement = doc.createElementNS("http://java.sun.com/xml/ns/jaxb", "jaxb:package");
        pkgElement.setAttributeNS(null, "name", pkgName);
        annoElement.appendChild(appInfo);
        appInfo.appendChild(schemaBindings);
        schemaBindings.appendChild(pkgElement);
        rootElement.appendChild(annoElement);
        File tmpFile = null;
        FileOutputStream fout = null;
        try {
            tmpFile = FileUtils.createTempFile("customzied", ".xsd");
            fout = new FileOutputStream(tmpFile);
            DOMUtils.writeXml(rootElement, fout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return tmpFile;
    }
}

