/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class BinaryDataProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private static final String HTTP_RANGE_PROPERTY = "http.range.support";
    private static final int BUFFER_SIZE = 4096;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return byte[].class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || Reader.class.isAssignableFrom(type);
    }

    public T readFrom(Class<T> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        if (InputStream.class.isAssignableFrom(clazz)) {
            return clazz.cast(is);
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return clazz.cast(new InputStreamReader(is, this.getEncoding(type)));
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return clazz.cast(IOUtils.readBytesFromStream(is));
        }
        throw new IOException("Unrecognized class");
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (byte[].class.isAssignableFrom(t.getClass())) {
            return ((byte[])t).length;
        }
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return byte[].class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || File.class.isAssignableFrom(type) || Reader.class.isAssignableFrom(type) || StreamingOutput.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(T o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (InputStream.class.isAssignableFrom(o.getClass())) {
            this.copyInputToOutput((InputStream)o, os, headers);
        } else if (File.class.isAssignableFrom(o.getClass())) {
            this.copyInputToOutput(new BufferedInputStream(new FileInputStream((File)o)), os, headers);
        } else if (byte[].class.isAssignableFrom(o.getClass())) {
            this.copyInputToOutput(new ByteArrayInputStream((byte[])o), os, headers);
        } else if (Reader.class.isAssignableFrom(o.getClass())) {
            try {
                OutputStreamWriter writer = new OutputStreamWriter(os, this.getEncoding(type));
                IOUtils.copy((Reader)o, writer, 4096);
                ((Writer)writer).flush();
            }
            finally {
                ((Reader)o).close();
            }
        } else if (StreamingOutput.class.isAssignableFrom(o.getClass())) {
            ((StreamingOutput)o).write(os);
        } else {
            throw new IOException("Unrecognized class");
        }
    }

    private String getEncoding(MediaType mt) {
        String enc = (String)mt.getParameters().get("charset");
        return enc == null ? "UTF-8" : enc;
    }

    protected void copyInputToOutput(InputStream is, OutputStream os, MultivaluedMap<String, Object> outHeaders) throws IOException {
        if (this.isRangeSupported()) {
            Message inMessage = PhaseInterceptorChain.getCurrentMessage().getExchange().getInMessage();
            this.handleRangeRequest(is, os, new HttpHeadersImpl(inMessage), outHeaders);
        } else {
            IOUtils.copyAndCloseInput(is, os);
        }
    }

    protected void handleRangeRequest(InputStream is, OutputStream os, HttpHeaders inHeaders, MultivaluedMap<String, Object> outHeaders) throws IOException {
        String range = (String)inHeaders.getRequestHeaders().getFirst((Object)"Range");
        if (range == null) {
            IOUtils.copyAndCloseInput(is, os);
        }
    }

    protected boolean isRangeSupported() {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null) {
            return MessageUtils.isTrue(message.get(HTTP_RANGE_PROPERTY));
        }
        return false;
    }
}

