/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.impl.AbstractRequestContextImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.RequestImpl;
import org.apache.cxf.jaxrs.impl.SecurityContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

public class ContainerRequestContextImpl
extends AbstractRequestContextImpl
implements ContainerRequestContext {
    private static final String ENDPOINT_ADDRESS_PROPERTY = "org.apache.cxf.transport.endpoint.address";
    private boolean preMatch;

    public ContainerRequestContextImpl(Message message, boolean preMatch, boolean responseContext) {
        super(message, responseContext);
        this.preMatch = preMatch;
    }

    public InputStream getEntityStream() {
        return this.m.get(InputStream.class);
    }

    public Request getRequest() {
        return new RequestImpl(this.m);
    }

    public SecurityContext getSecurityContext() {
        return new SecurityContextImpl(this.m);
    }

    public UriInfo getUriInfo() {
        return new UriInfoImpl(this.m);
    }

    public boolean hasEntity() {
        return this.getEntityStream() != null;
    }

    public void setEntityStream(InputStream is) {
        this.checkContext();
        this.m.put(InputStream.class, is);
    }

    public MultivaluedMap<String, String> getHeaders() {
        this.h = null;
        return new MetadataMap<String, String>((Map)this.m.get(Message.PROTOCOL_HEADERS), false, true, true);
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        if (!this.preMatch) {
            throw new IllegalStateException();
        }
        HttpUtils.resetRequestURI(this.m, requestUri.toString());
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.setRequestUri(requestUri);
        Object servletRequest = this.m.get("HTTP.REQUEST");
        if (servletRequest != null) {
            ((HttpServletRequest)servletRequest).setAttribute(ENDPOINT_ADDRESS_PROPERTY, (Object)baseUri.toString());
        }
    }

    public void setSecurityContext(SecurityContext sc) {
        this.m.put(SecurityContext.class, sc);
    }
}

