/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.utils;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.ServiceModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextUtils {
    private ContextUtils() {
    }

    public static boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey("org.apache.cxf.client"));
    }

    public static boolean isOutbound(Message message) {
        Exchange exchange = message.getExchange();
        return exchange != null && message == exchange.getOutMessage();
    }

    public static DataWriter<XMLEventWriter> getDataWriter(CorbaMessage message) {
        Service service = ServiceModelUtil.getService(message.getExchange());
        DataWriter<XMLEventWriter> dataWriter = service.getDataBinding().createWriter(XMLEventWriter.class);
        if (dataWriter == null) {
            // empty if block
        }
        return dataWriter;
    }

    public static DataReader<XMLEventReader> getDataReader(CorbaMessage message) {
        Service service = ServiceModelUtil.getService(message.getExchange());
        DataReader<XMLEventReader> dataReader = service.getDataBinding().createReader(XMLEventReader.class);
        if (dataReader == null) {
            // empty if block
        }
        return dataReader;
    }
}

