/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.services;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth.services.AccessTokenService;
import org.apache.cxf.rs.security.oauth.services.AuthorizationRequestService;
import org.apache.cxf.rs.security.oauth.services.RequestTokenService;

@Path(value="/")
public class OAuthDefaultServices {
    private AuthorizationRequestService authorizeService = new AuthorizationRequestService();
    private AccessTokenService accessTokenService = new AccessTokenService();
    private RequestTokenService requestTokenService = new RequestTokenService();

    @Context
    public void setMessageContext(MessageContext mc) {
        this.authorizeService.setMessageContext(mc);
        this.accessTokenService.setMessageContext(mc);
        this.requestTokenService.setMessageContext(mc);
    }

    public void setAuthorizationService(AuthorizationRequestService service) {
        this.authorizeService = service;
    }

    public void setAccessTokenService(AccessTokenService service) {
        this.accessTokenService = service;
    }

    public void setRequestTokenservice(RequestTokenService service) {
        this.requestTokenService = service;
    }

    @POST
    @Path(value="/initiate")
    @Produces(value={"application/x-www-form-urlencoded"})
    public Response getRequestToken() {
        return this.requestTokenService.getRequestToken();
    }

    @GET
    @Path(value="/initiate")
    @Produces(value={"application/x-www-form-urlencoded"})
    public Response getRequestTokenWithGET() {
        return this.requestTokenService.getRequestToken();
    }

    @GET
    @Path(value="/authorize")
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorize() {
        return this.authorizeService.authorize();
    }

    @GET
    @Path(value="/authorize/decision")
    public Response authorizeDecision() {
        return this.authorizeService.authorizeDecision();
    }

    @POST
    @Path(value="/authorize/decision")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authorizeDecisionForm() {
        return this.authorizeService.authorizeDecision();
    }

    @GET
    @Path(value="/token")
    @Produces(value={"application/x-www-form-urlencoded"})
    public Response getAccessTokenWithGET() {
        return this.accessTokenService.getAccessToken();
    }

    @POST
    @Path(value="/token")
    @Produces(value={"application/x-www-form-urlencoded"})
    public Response getAccessToken() {
        return this.accessTokenService.getAccessToken();
    }
}

