/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.corba.CorbaBinding;
import org.apache.cxf.binding.corba.CorbaConduit;
import org.apache.cxf.binding.corba.CorbaDestination;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamFaultInInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamFaultOutInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamInInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamOutInterceptor;
import org.apache.cxf.binding.corba.utils.OrbConfig;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.BareOutInterceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class CorbaBindingFactory
extends AbstractBindingFactory
implements ConduitInitiator,
DestinationFactory {
    public static final Collection<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/bindings/corba", "http://schemas.apache.org/yoko/bindings/corba");
    protected List<String> transportIds = new ArrayList<String>(DEFAULT_NAMESPACES);
    protected OrbConfig orbConfig = new OrbConfig();

    public CorbaBindingFactory(Bus b) {
        super(b, DEFAULT_NAMESPACES);
        this.registerWithDestinationManager();
        this.registerWithConduitManager();
    }

    @PostConstruct
    final void registerWithDestinationManager() {
        if (null == this.bus) {
            return;
        }
        DestinationFactoryManager dfm = this.bus.getExtension(DestinationFactoryManager.class);
        if (null != dfm && this.activationNamespaces != null) {
            for (String ns : this.activationNamespaces) {
                dfm.registerDestinationFactory(ns, this);
            }
        }
    }

    @PostConstruct
    final void registerWithConduitManager() {
        if (null == this.bus) {
            return;
        }
        ConduitInitiatorManager cim = this.bus.getExtension(ConduitInitiatorManager.class);
        if (null != cim && this.activationNamespaces != null) {
            for (String ns : this.activationNamespaces) {
                cim.registerConduitInitiator(ns, this);
            }
        }
    }

    public void setOrbClass(String cls) {
        this.orbConfig.setOrbClass(cls);
    }

    public void setOrbSingletonClass(String cls) {
        this.orbConfig.setOrbSingletonClass(cls);
    }

    @Override
    public Binding createBinding(BindingInfo bindingInfo) {
        CorbaBinding binding = new CorbaBinding();
        binding.getInFaultInterceptors().add(new CorbaStreamFaultInInterceptor());
        binding.getOutFaultInterceptors().add(new CorbaStreamFaultOutInterceptor());
        binding.getOutInterceptors().add(new BareOutInterceptor());
        binding.getOutInterceptors().add(new CorbaStreamOutInterceptor());
        binding.getInInterceptors().add(new BareInInterceptor());
        binding.getInInterceptors().add(new CorbaStreamInInterceptor());
        binding.setBindingInfo(bindingInfo);
        return binding;
    }

    @Override
    public Conduit getConduit(EndpointInfo endpointInfo) throws IOException {
        return this.getConduit(endpointInfo, null);
    }

    @Override
    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        return new CorbaConduit(endpointInfo, target, this.orbConfig);
    }

    @Override
    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        return new CorbaDestination(endpointInfo, this.orbConfig);
    }

    @Override
    public List<String> getTransportIds() {
        return this.transportIds;
    }

    public void setTransportIds(List<String> ids) {
        this.transportIds = ids;
    }

    public void setOrbArgs(List<String> args) {
        this.orbConfig.setOrbArgs(args);
    }

    @Override
    public Set<String> getUriPrefixes() {
        HashSet<String> uriPrefixes = new HashSet<String>();
        uriPrefixes.add("IOR");
        uriPrefixes.add("ior");
        uriPrefixes.add("file");
        uriPrefixes.add("relfile");
        uriPrefixes.add("corba");
        return uriPrefixes;
    }

    public OrbConfig getOrbConfig() {
        return this.orbConfig;
    }

    public void setOrbConfig(OrbConfig config) {
        this.orbConfig = config;
    }
}

