/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.cxf.ws.policy.PolicyVerificationOutInterceptor;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class PolicyOutInterceptor
extends AbstractPolicyInterceptor {
    public static final PolicyOutInterceptor INSTANCE = new PolicyOutInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyOutInterceptor.class);

    public PolicyOutInterceptor() {
        super("org.apache.cxf.ws.policy.PolicyOutInterceptor", "setup");
    }

    protected void handle(Message msg) {
        Exchange exchange = msg.getExchange();
        Bus bus = exchange.get(Bus.class);
        BindingOperationInfo boi = exchange.get(BindingOperationInfo.class);
        if (null == boi) {
            LOG.fine("No binding operation info.");
            return;
        }
        Endpoint e = exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        PolicyEngine pe = bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        ArrayList<Interceptor<? extends Message>> interceptors = new ArrayList<Interceptor<? extends Message>>();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        Policy p = (Policy)msg.getContextualProperty("org.apache.cxf.ws.policy.override");
        if (p != null) {
            EndpointPolicyImpl endpi = new EndpointPolicyImpl(p);
            EffectivePolicyImpl effectivePolicyImpl = new EffectivePolicyImpl();
            effectivePolicyImpl.initialise(endpi, (PolicyEngineImpl)pe, false);
            msg.put(EffectivePolicy.class, effectivePolicyImpl);
            PolicyUtils.logPolicy(LOG, Level.FINEST, "Using effective policy: ", (PolicyComponent)effectivePolicyImpl.getPolicy());
            interceptors.addAll(effectivePolicyImpl.getInterceptors());
            assertions.addAll(effectivePolicyImpl.getChosenAlternative());
        } else if (MessageUtils.isRequestor(msg)) {
            Conduit conduit = exchange.getConduit(msg);
            EffectivePolicy effectivePolicy = pe.getEffectiveClientRequestPolicy(ei, boi, conduit);
            msg.put(EffectivePolicy.class, effectivePolicy);
            PolicyUtils.logPolicy(LOG, Level.FINEST, "Using effective policy: ", (PolicyComponent)effectivePolicy.getPolicy());
            if (effectivePolicy != null) {
                interceptors.addAll(effectivePolicy.getInterceptors());
                assertions.addAll(effectivePolicy.getChosenAlternative());
            }
        } else {
            Destination destination = exchange.getDestination();
            List list = (List)exchange.get("ws-policy.validated.alternatives");
            EffectivePolicy effectivePolicy2 = pe.getEffectiveServerResponsePolicy(ei, boi, destination, list);
            msg.put(EffectivePolicy.class, effectivePolicy2);
            PolicyUtils.logPolicy(LOG, Level.FINEST, "Using effective policy: ", (PolicyComponent)effectivePolicy2.getPolicy());
            if (effectivePolicy2 != null) {
                interceptors.addAll(effectivePolicy2.getInterceptors());
                assertions.addAll(effectivePolicy2.getChosenAlternative());
            }
        }
        for (Interceptor interceptor : interceptors) {
            msg.getInterceptorChain().add(interceptor);
            LOG.log(Level.FINE, "Added interceptor of type {0}", interceptor.getClass().getSimpleName());
        }
        if (null != assertions && !assertions.isEmpty()) {
            if (LOG.isLoggable(Level.FINEST)) {
                StringBuilder buf = new StringBuilder();
                buf.append("Chosen alternative: ");
                String string = SystemPropertyAction.getProperty("line.separator");
                buf.append(string);
                for (Assertion a : assertions) {
                    PolicyUtils.printPolicyComponent((PolicyComponent)a, buf, 1);
                }
                LOG.finest(buf.toString());
            }
            msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
            msg.getInterceptorChain().add(PolicyVerificationOutInterceptor.INSTANCE);
        }
    }
}

