/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.mex;

import java.util.List;
import java.util.Map;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.Addressing;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.mex.MEXUtils;
import org.apache.cxf.ws.mex.MetadataExchange;
import org.apache.cxf.ws.mex.model._2004_09.GetMetadata;
import org.apache.cxf.ws.mex.model._2004_09.Metadata;
import org.apache.cxf.ws.mex.model._2004_09.MetadataReference;
import org.apache.cxf.ws.mex.model._2004_09.MetadataSection;
import org.apache.cxf.ws.mex.model._2004_09.ObjectFactory;
import org.w3c.dom.Element;

@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
@BindingType(value="http://www.w3.org/2003/05/soap/bindings/HTTP/")
@Addressing(required=true, enabled=true)
@XmlSeeAlso(value={ObjectFactory.class})
public class MEXEndpoint
implements MetadataExchange {
    Server server;

    public MEXEndpoint(EndpointImpl server) {
        this(server.getServer());
    }

    public MEXEndpoint(Server server) {
        this.server = server;
    }

    private String getAddressingNamespace() {
        return PhaseInterceptorChain.getCurrentMessage().get(AddressingProperties.class).getNamespaceURI();
    }

    public Metadata get2004() {
        Map<String, String> policies;
        Metadata metadata = new Metadata();
        List<Element> wsdls = MEXUtils.getWSDLs(this.server);
        for (Element el : wsdls) {
            MetadataSection sect = new MetadataSection();
            sect.setAny(el);
            sect.setIdentifier(el.getAttribute("targetNamespace"));
            sect.setDialect("http://schemas.xmlsoap.org/wsdl/");
            metadata.getMetadataSection().add(sect);
        }
        Map<String, String> schemas = MEXUtils.getSchemaLocations(this.server);
        if (schemas != null && !schemas.isEmpty()) {
            for (Map.Entry<String, String> s : schemas.entrySet()) {
                MetadataSection sect = new MetadataSection();
                sect.setDialect("http://www.w3.org/2001/XMLSchema");
                sect.setIdentifier(s.getKey());
                sect.setLocation(s.getValue());
                metadata.getMetadataSection().add(sect);
            }
        }
        if ((policies = MEXUtils.getPolicyLocations(this.server)) != null && !policies.isEmpty()) {
            for (Map.Entry<String, String> s : policies.entrySet()) {
                MetadataSection sect = new MetadataSection();
                sect.setDialect("http://schemas.xmlsoap.org/ws/2004/09/policy");
                sect.setIdentifier(s.getKey());
                MetadataReference ref = new MetadataReference();
                Element el = DOMUtils.createDocument().createElementNS(this.getAddressingNamespace(), "wsa:Address");
                el.setTextContent(s.getValue());
                ref.getAny().add(el);
                sect.setMetadataReference(ref);
                metadata.getMetadataSection().add(sect);
            }
        }
        return metadata;
    }

    public Metadata getMetadata(GetMetadata body) {
        Metadata metadata;
        block6: {
            String id;
            String dialect;
            block7: {
                block5: {
                    dialect = body.getDialect();
                    id = body.getIdentifier();
                    metadata = new Metadata();
                    if (!"http://schemas.xmlsoap.org/wsdl/".equals(dialect)) break block5;
                    List<Element> wsdls = MEXUtils.getWSDLs(this.server);
                    for (Element el : wsdls) {
                        MetadataSection sect = new MetadataSection();
                        sect.setAny(el);
                        sect.setDialect("http://schemas.xmlsoap.org/wsdl/");
                        metadata.getMetadataSection().add(sect);
                    }
                    break block6;
                }
                if (!"http://www.w3.org/2001/XMLSchema".equals(dialect)) break block7;
                List<Element> schemas = MEXUtils.getSchemas(this.server, id);
                for (Element el : schemas) {
                    MetadataSection sect = new MetadataSection();
                    sect.setAny(el);
                    sect.setDialect("http://www.w3.org/2001/XMLSchema");
                    sect.setIdentifier(DOMUtils.getAttributeValueEmptyNull(el, "targetNamespace"));
                    metadata.getMetadataSection().add(sect);
                }
                break block6;
            }
            if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(dialect)) break block6;
            List<Element> policies = MEXUtils.getPolicies(this.server, id);
            for (Element el : policies) {
                MetadataSection sect = new MetadataSection();
                sect.setAny(el);
                sect.setDialect("http://schemas.xmlsoap.org/ws/2004/09/policy");
                if (id == null) {
                    sect.setIdentifier(DOMUtils.getAttributeValueEmptyNull(el, "Name"));
                } else {
                    sect.setIdentifier(id);
                }
                metadata.getMetadataSection().add(sect);
            }
        }
        return metadata;
    }
}

