/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.EncoderDecoder10AImpl;
import org.apache.cxf.ws.rm.EncoderDecoder10Impl;
import org.apache.cxf.ws.rm.EncoderDecoder11Impl;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProtocolVariation {
    RM10WSA200408(EncoderDecoder10Impl.INSTANCE, RM10Constants.INSTANCE),
    RM10WSA200508(EncoderDecoder10AImpl.INSTANCE, RM10Constants.INSTANCE),
    RM11WSA200508(EncoderDecoder11Impl.INSTANCE, RM11Constants.INSTANCE);

    private final EncoderDecoder codec;
    private final RMConstants constants;

    private ProtocolVariation(EncoderDecoder ed, RMConstants rmc) {
        this.codec = ed;
        this.constants = rmc;
    }

    public EncoderDecoder getCodec() {
        return this.codec;
    }

    public RMConstants getConstants() {
        return this.constants;
    }

    public String getWSRMNamespace() {
        return this.codec.getWSRMNamespace();
    }

    public String getWSANamespace() {
        return this.codec.getWSANamespace();
    }

    public static ProtocolVariation findVariant(String wsrm, String wsa) {
        for (ProtocolVariation variant : ProtocolVariation.values()) {
            if (!variant.getWSRMNamespace().equals(wsrm) || !variant.getWSANamespace().equals(wsa)) continue;
            return variant;
        }
        return null;
    }
}

