/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache;

import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.ws.security.cache.ReplayCache;

public class EHCacheReplayCache
implements ReplayCache {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;
    private Cache cache;
    private CacheManager cacheManager;
    private long ttl = 3600L;

    public EHCacheReplayCache(String key, URL configFileURL) {
        if (this.cacheManager == null) {
            this.cacheManager = configFileURL == null ? CacheManager.create() : CacheManager.create((URL)configFileURL);
        }
        if (!this.cacheManager.cacheExists(key)) {
            this.cache = new Cache(key, 50000, true, false, 3600L, 3600L);
            this.cacheManager.addCache(this.cache);
        } else {
            this.cache = this.cacheManager.getCache(key);
        }
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    public void add(String identifier) {
        this.add(identifier, this.ttl);
    }

    public void add(String identifier, long timeToLive) {
        if (identifier == null || "".equals(identifier)) {
            return;
        }
        int parsedTTL = (int)timeToLive;
        if ((timeToLive != (long)parsedTTL || parsedTTL < 0 || (long)parsedTTL > 43200L) && this.ttl != (long)(parsedTTL = (int)this.ttl)) {
            parsedTTL = 3600;
        }
        this.cache.put(new Element((Object)identifier, (Object)identifier, Boolean.valueOf(false), Integer.valueOf(parsedTTL), Integer.valueOf(parsedTTL)));
    }

    public boolean contains(String identifier) {
        Element element = this.cache.get((Serializable)((Object)identifier));
        if (element != null) {
            if (this.cache.isExpired(element)) {
                this.cache.remove((Serializable)((Object)identifier));
                return false;
            }
            return true;
        }
        return false;
    }
}

