/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.NSManager;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaRedefine;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceWSDLBuilder {
    private final Map<String, String> ns2prefix;
    private Definition definition;
    private final List<ServiceInfo> services;
    private boolean useSchemaImports;
    private String baseFileName;
    private int xsdCount;
    private final Bus bus;
    private final NSManager nsMan;
    private Document docDoc;

    public ServiceWSDLBuilder(Bus b, List<ServiceInfo> services) {
        this.services = services;
        this.bus = b;
        this.ns2prefix = new HashMap<String, String>();
        this.nsMan = new NSManager();
    }

    public ServiceWSDLBuilder(Bus b, ServiceInfo ... services) {
        this(b, Arrays.asList(services));
    }

    public void setUseSchemaImports(boolean b) {
        this.useSchemaImports = b;
    }

    public void setBaseFileName(String s) {
        this.baseFileName = s;
    }

    public Definition build() throws WSDLException {
        this.useSchemaImports = false;
        return this.build(null);
    }

    public Definition build(Map<String, SchemaInfo> imports) throws WSDLException {
        try {
            this.definition = this.services.get(0).getProperty(WSDLServiceBuilder.WSDL_DEFINITION, Definition.class);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (this.definition == null) {
            ServiceInfo si = this.services.get(0);
            this.definition = this.newDefinition(si.getName(), si.getTargetNamespace());
            this.addNamespace("tns", si.getTargetNamespace(), this.definition);
            this.addExtensibilityElements((ElementExtensible)this.definition, this.getWSDL11Extensors(si.getDescription()));
            HashSet<PortType> portTypes = new HashSet<PortType>();
            for (ServiceInfo service : this.services) {
                Definition portTypeDef = this.definition;
                if (!this.isSameTNS(service)) {
                    portTypeDef = this.newDefinition(service.getInterface().getName(), service.getInterface().getName().getNamespaceURI());
                    Import wsdlImport = this.definition.createImport();
                    String tns = service.getInterface().getName().getNamespaceURI();
                    wsdlImport.setDefinition(portTypeDef);
                    wsdlImport.setNamespaceURI(tns);
                    wsdlImport.setLocationURI(service.getInterface().getName().getLocalPart() + ".wsdl");
                    this.definition.addImport(wsdlImport);
                    this.addNamespace(this.getPrefix(tns), tns, this.definition);
                }
                portTypes.add(this.buildPortType(service.getInterface(), portTypeDef));
                if (service.getSchemas() == null || service.getSchemas().size() <= 0) continue;
                this.buildTypes(service.getSchemas(), imports, portTypeDef);
            }
            for (ServiceInfo service : this.services) {
                this.buildBinding(service.getBindings(), portTypes);
                this.buildService(service);
            }
        }
        return this.definition;
    }

    private boolean isSameTNS(ServiceInfo service) {
        return service.getName().getNamespaceURI().equals(service.getInterface().getName().getNamespaceURI());
    }

    private Definition newDefinition(QName name, String targetNamespace) {
        Definition d = this.bus.getExtension(WSDLManager.class).getWSDLFactory().newDefinition();
        d.setExtensionRegistry(this.bus.getExtension(WSDLManager.class).getExtensionRegistry());
        d.setQName(name);
        d.setTargetNamespace(targetNamespace);
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema", d);
        return d;
    }

    public List<ExtensibilityElement> getWSDL11Extensors(AbstractPropertiesHolder holder) {
        if (holder == null) {
            return null;
        }
        return holder.getExtensors(ExtensibilityElement.class);
    }

    protected void addDocumentation(WSDLElement wsdlel, String text) {
        if (text == null) {
            return;
        }
        if (this.docDoc == null) {
            try {
                this.docDoc = XMLUtils.newDocument();
            }
            catch (ParserConfigurationException e) {
                // empty catch block
            }
        }
        Element el = this.docDoc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:documentation");
        el.setTextContent(text);
        wsdlel.setDocumentationElement(el);
    }

    protected void addExtensibilityElements(ElementExtensible elementExtensible, List<ExtensibilityElement> extensibilityElements) {
        if (extensibilityElements != null) {
            for (ExtensibilityElement element : extensibilityElements) {
                if (element instanceof UnknownExtensibilityElement) {
                    UnknownExtensibilityElement uee = (UnknownExtensibilityElement)element;
                    String pfx = uee.getElement().getPrefix();
                    this.addNamespace(pfx, element.getElementType().getNamespaceURI());
                } else {
                    QName qn = element.getElementType();
                    this.addNamespace(qn.getNamespaceURI());
                }
                elementExtensible.addExtensibilityElement(element);
            }
        }
    }

    private void addExtensibilityAttributes(AttributeExtensible attributeExtensible, Map<QName, Object> attributes) {
        if (attributes == null) {
            return;
        }
        for (QName qname : attributes.keySet()) {
            this.addNamespace(qname.getNamespaceURI());
            attributeExtensible.setExtensionAttribute(qname, attributes.get(qname));
        }
    }

    protected void buildTypes(Collection<SchemaInfo> schemas, Map<String, SchemaInfo> imports, Definition def) {
        Types types = def.createTypes();
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("DOM configuration problem", e);
        }
        Element nd = XMLUtils.createElementNS(doc, new QName("http://www.w3.org/2001/XMLSchema", "schema"));
        nd.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        doc.appendChild(nd);
        for (SchemaInfo schemaInfo : schemas) {
            if (!this.useSchemaImports) {
                SchemaImpl schemaImpl = new SchemaImpl();
                schemaImpl.setRequired(Boolean.valueOf(true));
                schemaImpl.setElementType(WSDLConstants.QNAME_SCHEMA);
                schemaImpl.setElement(schemaInfo.getElement());
                for (XmlSchemaExternal ext : schemaInfo.getSchema().getExternals()) {
                    SchemaImpl schemaImpl2;
                    SchemaImport imp;
                    if (ext.getSchema() == null) continue;
                    if (ext instanceof XmlSchemaImport) {
                        imp = schemaImpl.createImport();
                        imp.setNamespaceURI(((XmlSchemaImport)ext).getNamespace());
                        imp.setSchemaLocationURI(((XmlSchemaImport)ext).getSchemaLocation());
                        schemaImpl2 = new SchemaImpl();
                        schemaImpl2.setRequired(Boolean.valueOf(true));
                        schemaImpl2.setElementType(WSDLConstants.QNAME_SCHEMA);
                        schemaImpl2.setDocumentBaseURI(ext.getSchema().getSourceURI());
                        try {
                            schemaImpl2.setElement(ext.getSchema().getSchemaDocument().getDocumentElement());
                        }
                        catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
                            // empty catch block
                        }
                        imp.setReferencedSchema((Schema)schemaImpl2);
                        schemaImpl.addImport(imp);
                        continue;
                    }
                    if (ext instanceof XmlSchemaInclude) {
                        imp = schemaImpl.createInclude();
                        imp.setSchemaLocationURI(((XmlSchemaInclude)ext).getSchemaLocation());
                        schemaImpl2 = new SchemaImpl();
                        schemaImpl2.setRequired(Boolean.valueOf(true));
                        schemaImpl2.setElementType(WSDLConstants.QNAME_SCHEMA);
                        schemaImpl2.setDocumentBaseURI(ext.getSchema().getSourceURI());
                        try {
                            schemaImpl2.setElement(ext.getSchema().getSchemaDocument().getDocumentElement());
                        }
                        catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
                            // empty catch block
                        }
                        imp.setReferencedSchema((Schema)schemaImpl2);
                        schemaImpl.addInclude((SchemaReference)imp);
                        continue;
                    }
                    if (!(ext instanceof XmlSchemaRedefine)) continue;
                    imp = schemaImpl.createRedefine();
                    imp.setSchemaLocationURI(((XmlSchemaRedefine)ext).getSchemaLocation());
                    schemaImpl2 = new SchemaImpl();
                    schemaImpl2.setRequired(Boolean.valueOf(true));
                    schemaImpl2.setElementType(WSDLConstants.QNAME_SCHEMA);
                    schemaImpl2.setDocumentBaseURI(ext.getSchema().getSourceURI());
                    try {
                        schemaImpl2.setElement(ext.getSchema().getSchemaDocument().getDocumentElement());
                    }
                    catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
                        // empty catch block
                    }
                    imp.setReferencedSchema((Schema)schemaImpl2);
                    schemaImpl.addRedefine((SchemaReference)imp);
                }
                types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
                continue;
            }
            String name = this.baseFileName + "_schema" + ++this.xsdCount + ".xsd";
            Element imp = XMLUtils.createElementNS(doc, new QName("http://www.w3.org/2001/XMLSchema", "import"));
            imp.setAttribute("schemaLocation", name);
            imp.setAttribute("namespace", schemaInfo.getNamespaceURI());
            nd.appendChild(imp);
            imports.put(name, schemaInfo);
        }
        if (this.useSchemaImports) {
            SchemaImpl schemaImpl = new SchemaImpl();
            schemaImpl.setRequired(Boolean.valueOf(true));
            schemaImpl.setElementType(WSDLConstants.QNAME_SCHEMA);
            schemaImpl.setElement(nd);
            types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
        }
        def.setTypes(types);
    }

    protected void buildBinding(Collection<BindingInfo> bindingInfos, Collection<PortType> portTypes) {
        Binding binding = null;
        for (BindingInfo bindingInfo : bindingInfos) {
            binding = this.definition.createBinding();
            this.addDocumentation((WSDLElement)binding, bindingInfo.getDocumentation());
            binding.setUndefined(false);
            for (PortType portType : portTypes) {
                if (!portType.getQName().equals(bindingInfo.getInterface().getName())) continue;
                binding.setPortType(portType);
                break;
            }
            binding.setQName(bindingInfo.getName());
            if (!bindingInfo.getName().getNamespaceURI().equals(this.definition.getTargetNamespace())) {
                this.addNamespace(bindingInfo.getName().getNamespaceURI());
            }
            this.buildBindingOperation(this.definition, binding, bindingInfo.getOperations());
            this.addExtensibilityElements((ElementExtensible)binding, this.getWSDL11Extensors(bindingInfo));
            this.definition.addBinding(binding);
        }
    }

    protected void buildBindingOperation(Definition def, Binding binding, Collection<BindingOperationInfo> bindingOperationInfos) {
        BindingOperation bindingOperation = null;
        for (BindingOperationInfo bindingOperationInfo : bindingOperationInfos) {
            bindingOperation = def.createBindingOperation();
            this.addDocumentation((WSDLElement)bindingOperation, bindingOperationInfo.getDocumentation());
            bindingOperation.setName(bindingOperationInfo.getName().getLocalPart());
            for (Operation operation : CastUtils.cast(binding.getPortType().getOperations(), Operation.class)) {
                if (!operation.getName().equals(bindingOperation.getName())) continue;
                bindingOperation.setOperation(operation);
                break;
            }
            this.buildBindingInput(def, bindingOperation, bindingOperationInfo.getInput());
            this.buildBindingOutput(def, bindingOperation, bindingOperationInfo.getOutput());
            this.buildBindingFault(def, bindingOperation, bindingOperationInfo.getFaults());
            this.addExtensibilityAttributes((AttributeExtensible)bindingOperation, bindingOperationInfo.getExtensionAttributes());
            this.addExtensibilityElements((ElementExtensible)bindingOperation, this.getWSDL11Extensors(bindingOperationInfo));
            binding.addBindingOperation(bindingOperation);
        }
    }

    protected void buildBindingFault(Definition def, BindingOperation bindingOperation, Collection<BindingFaultInfo> bindingFaultInfos) {
        BindingFault bindingFault = null;
        for (BindingFaultInfo bindingFaultInfo : bindingFaultInfos) {
            bindingFault = def.createBindingFault();
            this.addDocumentation((WSDLElement)bindingFault, bindingFaultInfo.getDocumentation());
            bindingFault.setName(bindingFaultInfo.getFaultInfo().getFaultName().getLocalPart());
            bindingOperation.addBindingFault(bindingFault);
            this.addExtensibilityAttributes((AttributeExtensible)bindingFault, bindingFaultInfo.getExtensionAttributes());
            this.addExtensibilityElements((ElementExtensible)bindingFault, this.getWSDL11Extensors(bindingFaultInfo));
        }
    }

    protected void buildBindingInput(Definition def, BindingOperation bindingOperation, BindingMessageInfo bindingMessageInfo) {
        BindingInput bindingInput = null;
        if (bindingMessageInfo != null) {
            bindingInput = def.createBindingInput();
            this.addDocumentation((WSDLElement)bindingInput, bindingMessageInfo.getDocumentation());
            bindingInput.setName(bindingMessageInfo.getMessageInfo().getName().getLocalPart());
            bindingOperation.setBindingInput(bindingInput);
            this.addExtensibilityAttributes((AttributeExtensible)bindingInput, bindingMessageInfo.getExtensionAttributes());
            this.addExtensibilityElements((ElementExtensible)bindingInput, this.getWSDL11Extensors(bindingMessageInfo));
        }
    }

    protected void buildBindingOutput(Definition def, BindingOperation bindingOperation, BindingMessageInfo bindingMessageInfo) {
        BindingOutput bindingOutput = null;
        if (bindingMessageInfo != null) {
            bindingOutput = def.createBindingOutput();
            this.addDocumentation((WSDLElement)bindingOutput, bindingMessageInfo.getDocumentation());
            bindingOutput.setName(bindingMessageInfo.getMessageInfo().getName().getLocalPart());
            bindingOperation.setBindingOutput(bindingOutput);
            this.addExtensibilityAttributes((AttributeExtensible)bindingOutput, bindingMessageInfo.getExtensionAttributes());
            this.addExtensibilityElements((ElementExtensible)bindingOutput, this.getWSDL11Extensors(bindingMessageInfo));
        }
    }

    protected void buildService(ServiceInfo serviceInfo) {
        Map<QName, MessageInfo> messages = serviceInfo.getMessages();
        for (Map.Entry<QName, MessageInfo> mie : messages.entrySet()) {
            if (!mie.getKey().getNamespaceURI().equals(this.definition.getTargetNamespace()) || this.definition.getMessage(mie.getKey()) != null) continue;
            Message message = this.definition.createMessage();
            this.addDocumentation((WSDLElement)message, mie.getValue().getMessageDocumentation());
            message.setUndefined(false);
            message.setQName(mie.getKey());
            for (MessagePartInfo mpi : mie.getValue().getMessageParts()) {
                Part part = this.definition.createPart();
                boolean elemental = mpi.isElement();
                if (elemental && null == serviceInfo.getXmlSchemaCollection().getElementByQName(mpi.getElementQName())) {
                    elemental = false;
                }
                if (elemental) {
                    part.setElementName(mpi.getElementQName());
                } else {
                    part.setTypeName(mpi.getTypeQName());
                }
                part.setName(mpi.getName().getLocalPart());
                message.addPart(part);
            }
            this.definition.addMessage(message);
        }
        this.addDocumentation((WSDLElement)this.definition, serviceInfo.getTopLevelDoc());
        Service serv = this.definition.createService();
        this.addDocumentation((WSDLElement)serv, serviceInfo.getDocumentation());
        serv.setQName(serviceInfo.getName());
        this.addNamespace(serviceInfo.getName().getNamespaceURI());
        this.addExtensibilityElements((ElementExtensible)serv, this.getWSDL11Extensors(serviceInfo));
        this.definition.addService(serv);
        for (EndpointInfo ei : serviceInfo.getEndpoints()) {
            this.addNamespace(ei.getTransportId());
            Port port = this.definition.createPort();
            this.addDocumentation((WSDLElement)port, ei.getDocumentation());
            port.setName(ei.getName().getLocalPart());
            port.setBinding(this.definition.getBinding(ei.getBinding().getName()));
            this.addExtensibilityElements((ElementExtensible)port, this.getWSDL11Extensors(ei));
            serv.addPort(port);
        }
    }

    protected PortType buildPortType(InterfaceInfo intf, Definition def) {
        PortType portType = null;
        try {
            portType = intf.getProperty(WSDLServiceBuilder.WSDL_PORTTYPE, PortType.class);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (portType == null) {
            portType = def.createPortType();
            portType.setQName(intf.getName());
            this.addDocumentation((WSDLElement)portType, intf.getDocumentation());
            this.addNamespace(intf.getName().getNamespaceURI(), def);
            this.addExtensibilityElements((ElementExtensible)portType, this.getWSDL11Extensors(intf));
            this.addExtensibilityAttributes((AttributeExtensible)portType, intf.getExtensionAttributes());
            portType.setUndefined(false);
            this.buildPortTypeOperation(portType, intf.getOperations(), def);
        }
        def.addPortType(portType);
        return portType;
    }

    protected void addNamespace(String namespaceURI, Definition def) {
        this.addNamespace(this.getPrefix(namespaceURI), namespaceURI, def);
    }

    protected void addNamespace(String namespaceURI) {
        this.addNamespace(this.getPrefix(namespaceURI), namespaceURI);
    }

    protected void addNamespace(String prefix, String namespaceURI) {
        this.addNamespace(prefix, namespaceURI, this.definition);
    }

    protected void addNamespace(String prefix, String namespaceURI, Definition def) {
        this.ns2prefix.put(namespaceURI, prefix);
        def.addNamespace(prefix, namespaceURI);
    }

    private OperationInfo getOperationInfo(OperationInfo operation) {
        if (operation.getUnwrappedOperation() != null) {
            return operation.getUnwrappedOperation();
        }
        return operation;
    }

    private Map<QName, Object> getInputExtensionAttributes(OperationInfo operation) {
        return this.getOperationInfo(operation).getInput().getExtensionAttributes();
    }

    private Map<QName, Object> getOutputExtensionAttributes(OperationInfo operation) {
        return this.getOperationInfo(operation).getOutput().getExtensionAttributes();
    }

    protected void buildPortTypeOperation(PortType portType, Collection<OperationInfo> operationInfos, Definition def) {
        for (OperationInfo operationInfo : operationInfos) {
            Operation operation = null;
            try {
                operation = operationInfo.getProperty(WSDLServiceBuilder.WSDL_OPERATION, Operation.class);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (operation == null) {
                operation = def.createOperation();
                this.addDocumentation((WSDLElement)operation, operationInfo.getDocumentation());
                operation.setUndefined(false);
                operation.setName(operationInfo.getName().getLocalPart());
                this.addNamespace(operationInfo.getName().getNamespaceURI(), def);
                if (operationInfo.isOneWay()) {
                    operation.setStyle(OperationType.ONE_WAY);
                }
                this.addExtensibilityElements((ElementExtensible)operation, this.getWSDL11Extensors(operationInfo));
                Input input = def.createInput();
                this.addDocumentation((WSDLElement)input, operationInfo.getInput().getDocumentation());
                input.setName(operationInfo.getInputName());
                Message message = def.createMessage();
                this.buildMessage(message, operationInfo.getInput(), def);
                this.addExtensibilityAttributes((AttributeExtensible)input, this.getInputExtensionAttributes(operationInfo));
                this.addExtensibilityElements((ElementExtensible)input, this.getWSDL11Extensors(operationInfo.getInput()));
                input.setMessage(message);
                operation.setInput(input);
                operation.setParameterOrdering(operationInfo.getParameterOrdering());
                if (operationInfo.getOutput() != null) {
                    Output output = def.createOutput();
                    this.addDocumentation((WSDLElement)output, operationInfo.getOutput().getDocumentation());
                    output.setName(operationInfo.getOutputName());
                    message = def.createMessage();
                    this.buildMessage(message, operationInfo.getOutput(), def);
                    this.addExtensibilityAttributes((AttributeExtensible)output, this.getOutputExtensionAttributes(operationInfo));
                    this.addExtensibilityElements((ElementExtensible)output, this.getWSDL11Extensors(operationInfo.getOutput()));
                    output.setMessage(message);
                    operation.setOutput(output);
                }
                Collection<FaultInfo> faults = operationInfo.getFaults();
                Fault fault = null;
                for (FaultInfo faultInfo : faults) {
                    fault = def.createFault();
                    this.addDocumentation((WSDLElement)fault, faultInfo.getDocumentation());
                    fault.setName(faultInfo.getFaultName().getLocalPart());
                    message = def.createMessage();
                    this.buildMessage(message, faultInfo, def);
                    this.addExtensibilityAttributes((AttributeExtensible)fault, faultInfo.getExtensionAttributes());
                    this.addExtensibilityElements((ElementExtensible)fault, this.getWSDL11Extensors(faultInfo));
                    fault.setMessage(message);
                    operation.addFault(fault);
                }
            }
            portType.addOperation(operation);
        }
    }

    private String getPrefix(String ns) {
        for (String namespace : this.nsMan.getNamespaces()) {
            if (!namespace.equals(ns)) continue;
            return this.nsMan.getPrefixFromNS(namespace);
        }
        String prefix = this.ns2prefix.get(ns);
        if (prefix == null) {
            prefix = this.getNewPrefix();
            this.ns2prefix.put(ns, prefix);
        }
        return prefix;
    }

    private String getNewPrefix() {
        String prefix = "ns1";
        int i = 0;
        while (this.ns2prefix.containsValue(prefix)) {
            prefix = "ns" + ++i;
        }
        return prefix;
    }

    protected void buildMessage(Message message, AbstractMessageContainer messageContainer, Definition def) {
        this.addDocumentation((WSDLElement)message, messageContainer.getMessageDocumentation());
        message.setQName(messageContainer.getName());
        message.setUndefined(false);
        def.addMessage(message);
        List<MessagePartInfo> messageParts = messageContainer.getMessageParts();
        Part messagePart = null;
        for (MessagePartInfo messagePartInfo : messageParts) {
            messagePart = def.createPart();
            messagePart.setName(messagePartInfo.getName().getLocalPart());
            if (messagePartInfo.isElement()) {
                messagePart.setElementName(messagePartInfo.getElementQName());
                this.addNamespace(messagePartInfo.getElementQName().getNamespaceURI(), def);
            } else if (messagePartInfo.getTypeQName() != null) {
                messagePart.setTypeName(messagePartInfo.getTypeQName());
                this.addNamespace(messagePartInfo.getTypeQName().getNamespaceURI(), def);
            }
            message.addPart(messagePart);
        }
    }
}

