/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SecurityContextToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.util.WSSecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextTokenPolicyValidator
extends AbstractTokenPolicyValidator {
    private List<WSSecurityEngineResult> sctResults;
    private Message message;

    public SecurityContextTokenPolicyValidator(Message message, List<WSSecurityEngineResult> results) {
        this.message = message;
        this.sctResults = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(results, (int)1024, this.sctResults);
    }

    public boolean validatePolicy(AssertionInfoMap aim) {
        Collection sctAis = (Collection)aim.get(SP12Constants.SECURITY_CONTEXT_TOKEN);
        if (sctAis != null && !sctAis.isEmpty()) {
            for (AssertionInfo ai : sctAis) {
                SecurityContextToken sctPolicy = (SecurityContextToken)ai.getAssertion();
                ai.setAsserted(true);
                boolean tokenRequired = this.isTokenRequired(sctPolicy, this.message);
                if (!tokenRequired || !this.sctResults.isEmpty()) continue;
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                return false;
            }
        }
        return true;
    }
}

