/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust10Builder
implements AssertionBuilder<Element> {
    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        if ((element = DOMUtils.getFirstElement(element)) == null || !element.getLocalName().equals("Policy")) {
            throw new IllegalArgumentException("Trust10 assertion doesn't contain any Policy");
        }
        Trust10 trust10 = new Trust10(SP11Constants.INSTANCE);
        if (DOMUtils.getFirstChildWithName(element, SP11Constants.MUST_SUPPORT_CLIENT_CHALLENGE) != null) {
            trust10.setMustSupportClientChallenge(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP11Constants.MUST_SUPPORT_SERVER_CHALLENGE) != null) {
            trust10.setMustSupportServerChallenge(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP11Constants.REQUIRE_CLIENT_ENTROPY) != null) {
            trust10.setRequireClientEntropy(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP11Constants.REQUIRE_SERVER_ENTROPY) != null) {
            trust10.setRequireServerEntropy(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP11Constants.MUST_SUPPORT_ISSUED_TOKENS) != null) {
            trust10.setMustSupportIssuedTokens(true);
        }
        return trust10;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.TRUST_10};
    }
}

