/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BusEntityResolver
extends DelegatingEntityResolver {
    private static final Logger LOG = LogUtils.getL7dLogger(BusEntityResolver.class);
    private EntityResolver dtdResolver;
    private EntityResolver schemaResolver;

    public BusEntityResolver(EntityResolver dr, EntityResolver sr) {
        super(dr, sr);
        this.dtdResolver = dr;
        this.schemaResolver = sr;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = super.resolveEntity(publicId, systemId);
        if (null == source && null != systemId) {
            LOG.log(Level.FINE, "Attempting to resolve systemId {0}", systemId);
            source = this.schemaResolver.resolveEntity(publicId, systemId);
            if (null == source) {
                source = this.dtdResolver.resolveEntity(publicId, systemId);
            }
        }
        return source;
    }
}

