/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.blueprint;

import java.net.URL;
import java.util.Set;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.cxf.bus.blueprint.BusDefinitionParser;
import org.apache.cxf.configuration.blueprint.SimpleBPBeanDefinitionParser;
import org.apache.cxf.feature.FastInfosetFeature;
import org.apache.cxf.feature.LoggingFeature;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFCoreNamespaceHandler
implements NamespaceHandler {
    public URL getSchemaLocation(String namespace) {
        if ("http://cxf.apache.org/blueprint/core".equals(namespace)) {
            return this.getClass().getClassLoader().getResource("/schemas/blueprint/core.xsd");
        }
        if ("http://cxf.apache.org/configuration/beans".equals(namespace)) {
            return this.getClass().getClassLoader().getResource("/schemas/configuration/cxf-beans.xsd");
        }
        if ("http://cxf.apache.org/configuration/parameterized-types".equals(namespace)) {
            return this.getClass().getClassLoader().getResource("/schemas/configuration/parameterized-types.xsd");
        }
        return null;
    }

    public Metadata parse(Element element, ParserContext context) {
        String s = element.getLocalName();
        if ("bus".equals(s)) {
            return new BusDefinitionParser().parse(element, context);
        }
        if ("logging".equals(s)) {
            return new SimpleBPBeanDefinitionParser(LoggingFeature.class).parse(element, context);
        }
        if ("fastinfoset".equals(s)) {
            return new SimpleBPBeanDefinitionParser(FastInfosetFeature.class).parse(element, context);
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return null;
    }
}

