/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http.interceptor;

import java.util.logging.Logger;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String RELATIVE_PATH = "relative.path";
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchInterceptor.class);

    public DispatchInterceptor() {
        super("pre-stream");
    }

    @Override
    public void handleMessage(Message message) {
        int idx;
        String path = (String)message.get(Message.PATH_INFO);
        String address = (String)message.get(Message.BASE_PATH);
        String method = (String)message.get("org.apache.cxf.request.method");
        if (address.startsWith("http") && (idx = address.indexOf(47, 7)) != -1) {
            address = address.substring(idx);
        }
        if (path.startsWith(address) && !(path = path.substring(address.length())).startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        message.put(RELATIVE_PATH, path);
        LOG.info("Invoking " + method + " on " + path);
        URIMapper mapper = (URIMapper)message.getExchange().get(Service.class).get(URIMapper.class.getName());
        BindingOperationInfo op = mapper.getOperation(path, method, message);
        if (op == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OP", LOG, method, path));
        }
        message.getExchange().put(BindingOperationInfo.class, op);
    }
}

