/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.neethi.Assertion;

public class ServerPolicyOutFaultInterceptor
extends AbstractPolicyInterceptor {
    public static final ServerPolicyOutFaultInterceptor INSTANCE = new ServerPolicyOutFaultInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(ServerPolicyOutFaultInterceptor.class);

    public ServerPolicyOutFaultInterceptor() {
        super("org.apache.cxf.ws.policy.ServerPolicyOutFaultInterceptor", "setup");
    }

    protected void handle(Message msg) {
        if (MessageUtils.isRequestor(msg)) {
            LOG.fine("Is a requestor.");
            return;
        }
        Exchange exchange = msg.getExchange();
        assert (null != exchange);
        BindingOperationInfo boi = exchange.get(BindingOperationInfo.class);
        if (null == boi) {
            LOG.fine("No binding operation info.");
            return;
        }
        Endpoint e = exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        Bus bus = exchange.get(Bus.class);
        PolicyEngine pe = bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Destination destination = exchange.getDestination();
        Exception ex = exchange.get(Exception.class);
        assert (null != ex);
        BindingFaultInfo bfi = this.getBindingFaultInfo(msg, ex, boi);
        if (null == bfi) {
            LOG.fine("No binding fault info.");
            return;
        }
        EffectivePolicy effectivePolicy = pe.getEffectiveServerFaultPolicy(ei, bfi, destination);
        List<Interceptor<? extends Message>> interceptors = effectivePolicy.getInterceptors();
        for (Interceptor<? extends Message> oi : interceptors) {
            msg.getInterceptorChain().add(oi);
            LOG.log(Level.FINE, "Added interceptor of type {0}", oi.getClass().getSimpleName());
        }
        Collection<Assertion> assertions = effectivePolicy.getChosenAlternative();
        if (null != assertions && !assertions.isEmpty()) {
            msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
        }
    }
}

