/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.BaseUrlHelper;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;

public class ServletController {
    protected static final String DEFAULT_LISTINGS_CLASSIFIER = "/services";
    private static final Logger LOG = LogUtils.getL7dLogger(ServletController.class);
    protected boolean isHideServiceList;
    protected boolean disableAddressUpdates;
    protected String forcedBaseAddress;
    protected String serviceListStyleSheet;
    protected String title;
    protected String serviceListRelativePath = "/services";
    protected ServletConfig servletConfig;
    protected DestinationRegistry destinationRegistry;
    protected HttpServlet serviceListGenerator;

    public ServletController(DestinationRegistry destinationRegistry, ServletConfig config, HttpServlet serviceListGenerator) {
        this.servletConfig = config;
        this.destinationRegistry = destinationRegistry;
        this.serviceListGenerator = serviceListGenerator;
        this.init();
    }

    public void setServiceListRelativePath(String relativePath) {
        this.serviceListRelativePath = relativePath;
    }

    public void setServiceListStyleSheet(String serviceListStyleSheet) {
        this.serviceListStyleSheet = serviceListStyleSheet;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    protected synchronized void updateDests(HttpServletRequest request) {
        this.updateDests(request, false);
    }

    protected void updateDests(HttpServletRequest request, boolean force) {
        String base = this.forcedBaseAddress == null ? BaseUrlHelper.getBaseURL(request) : this.forcedBaseAddress;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        Set<String> paths = this.destinationRegistry.getDestinationsPaths();
        for (String path : paths) {
            if (!force && pathInfo != null && !pathInfo.startsWith(path)) continue;
            AbstractHTTPDestination d2 = this.destinationRegistry.getDestinationForPath(path);
            String ad = d2.getEndpointInfo().getAddress();
            if (ad == null && d2.getAddress() != null && d2.getAddress().getAddress() != null && (ad = d2.getAddress().getAddress().getValue()) == null) {
                ad = "/";
            }
            if (ad == null || !ad.equals(path)) continue;
            if (this.disableAddressUpdates) {
                request.setAttribute("org.apache.cxf.transport.endpoint.address", (Object)(base + path));
                continue;
            }
            BaseUrlHelper.setAddress(d2, base + path);
        }
    }

    private void init() {
        String isForcedBaseAddress;
        String isDisableAddressUpdates;
        if (this.servletConfig == null) {
            return;
        }
        String hideServiceList = this.servletConfig.getInitParameter("hide-service-list-page");
        if (!StringUtils.isEmpty(hideServiceList)) {
            this.isHideServiceList = Boolean.valueOf(hideServiceList);
        }
        if (!StringUtils.isEmpty(isDisableAddressUpdates = this.servletConfig.getInitParameter("disable-address-updates"))) {
            this.disableAddressUpdates = Boolean.valueOf(isDisableAddressUpdates);
        }
        if (!StringUtils.isEmpty(isForcedBaseAddress = this.servletConfig.getInitParameter("base-address"))) {
            this.forcedBaseAddress = isForcedBaseAddress;
        }
        try {
            this.serviceListGenerator.init(this.servletConfig);
        }
        catch (ServletException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String serviceListPath = this.servletConfig.getInitParameter("service-list-path");
        if (!StringUtils.isEmpty(serviceListPath)) {
            this.serviceListRelativePath = serviceListPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpServletRequest request, HttpServletResponse res) throws ServletException {
        block16: {
            try {
                String pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
                AbstractHTTPDestination d = this.destinationRegistry.getDestinationForPath(pathInfo, true);
                if (d == null) {
                    if (!this.isHideServiceList && (request.getRequestURI().endsWith(this.serviceListRelativePath) || request.getRequestURI().endsWith(this.serviceListRelativePath + "/") || StringUtils.isEmpty(pathInfo) || "/".equals(pathInfo))) {
                        this.updateDests(request, true);
                        this.serviceListGenerator.service((ServletRequest)request, (ServletResponse)res);
                    } else {
                        d = this.destinationRegistry.checkRestfulRequest(pathInfo);
                        if (d == null || d.getMessageObserver() == null) {
                            LOG.warning("Can't find the the request for " + request.getRequestURL() + "'s Observer ");
                            this.generateNotFound(request, res);
                        } else {
                            this.updateDests(request);
                            this.invokeDestination(request, res, d);
                        }
                    }
                    break block16;
                }
                EndpointInfo ei = d.getEndpointInfo();
                Bus bus = d.getBus();
                ClassLoader orig = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader loader;
                    ResourceManager manager = bus.getExtension(ResourceManager.class);
                    if (manager != null && (loader = manager.resolveResource("", ClassLoader.class)) != null) {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                    QueryHandlerRegistry queryHandlerRegistry = bus.getExtension(QueryHandlerRegistry.class);
                    if (!StringUtils.isEmpty(request.getQueryString()) && queryHandlerRegistry != null) {
                        String baseUri;
                        String ctxUri;
                        QueryHandler selectedHandler;
                        if ("GET".equals(request.getMethod())) {
                            this.updateDests(request);
                        }
                        if ((selectedHandler = this.findQueryHandler(queryHandlerRegistry, ei, ctxUri = request.getPathInfo(), baseUri = request.getRequestURL().toString() + "?" + request.getQueryString())) != null) {
                            this.respondUsingQueryHandler(selectedHandler, res, ei, ctxUri, baseUri);
                            return;
                        }
                    } else {
                        this.updateDests(request);
                    }
                    this.invokeDestination(request, res, d);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(orig);
                }
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void invokeDestination(HttpServletRequest request, HttpServletResponse response, AbstractHTTPDestination d) throws ServletException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + Thread.currentThread());
        }
        try {
            d.invoke(this.servletConfig, this.servletConfig.getServletContext(), request, response);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    protected QueryHandler findQueryHandler(QueryHandlerRegistry queryHandlerRegistry, EndpointInfo ei, String ctxUri, String baseUri) {
        if (queryHandlerRegistry == null) {
            return null;
        }
        List<QueryHandler> handlers = queryHandlerRegistry.getHandlers();
        for (QueryHandler qh : handlers) {
            if (!qh.isRecognizedQuery(baseUri, ctxUri, ei)) continue;
            return qh;
        }
        return null;
    }

    protected void respondUsingQueryHandler(QueryHandler selectedHandler, HttpServletResponse res, EndpointInfo ei, String ctxUri, String baseUri) throws IOException, ServletException {
        res.setContentType(selectedHandler.getResponseContentType(baseUri, ctxUri));
        ServletOutputStream out = res.getOutputStream();
        try {
            selectedHandler.writeResponse(baseUri, ctxUri, ei, (OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            LOG.warning(selectedHandler.getClass().getName() + " Exception caught writing response: " + e.getMessage());
            throw new ServletException((Throwable)e);
        }
    }

    protected void generateNotFound(HttpServletRequest request, HttpServletResponse res) throws IOException {
        res.setStatus(404);
        res.setContentType("text/html");
        res.getWriter().write("<html><body>No service was found.</body></html>");
    }
}

