/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.AegisXMLStreamDataReader;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.basic.ArrayType;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataReader
implements DataReader<XMLStreamReader> {
    private AegisDatabinding databinding;
    private AegisXMLStreamDataReader reader;

    public XMLStreamDataReader(AegisDatabinding databinding, Bus bus) {
        this.databinding = databinding;
        this.reader = new AegisXMLStreamDataReader(databinding.getAegisContext());
    }

    @Override
    public Object read(MessagePartInfo part, XMLStreamReader input) {
        try {
            AegisType type = part.getProperty("org.apache.cxf.aegis.outerType", AegisType.class);
            if (type == null) {
                type = this.databinding.getType(part);
                return this.reader.read(input, type);
            }
            ArrayType arrayType = (ArrayType)type;
            return this.reader.readFlatArray(input, arrayType, part.getConcreteName());
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    @Override
    public Object read(QName name, XMLStreamReader input, Class typeClass) {
        MessagePartInfo info = this.databinding.getPartFromClass(typeClass);
        return info == null ? this.read(input) : this.read(info, input);
    }

    @Override
    public Object read(XMLStreamReader input) {
        try {
            return this.reader.read(input, (AegisType)null);
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.reader.getContext().setAttachments(attachments);
    }

    @Override
    public void setProperty(String prop, Object value) {
        this.reader.setProperty(prop, value);
    }

    @Override
    public void setSchema(Schema s) {
        this.reader.setSchema(s);
    }
}

