/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Port;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.HttpURLConnectionFactoryImpl;
import org.apache.cxf.transport.https.HttpsURLConnectionFactory;
import org.apache.cxf.wsdl.http.AddressType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPTransportFactory
extends AbstractTransportFactory
implements WSDLEndpointFactory {
    private static final Set<String> URI_PREFIXES = new HashSet<String>();

    public void setActivationNamespaces(Collection<String> ans) {
        this.setTransportIds(new ArrayList<String>(ans));
    }

    @Override
    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, Port port) {
        if (port != null) {
            List ees = port.getExtensibilityElements();
            for (Object extensor : ees) {
                if (extensor instanceof HTTPAddress) {
                    HTTPAddress httpAdd = (HTTPAddress)extensor;
                    HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                    ((EndpointInfo)info).setAddress(httpAdd.getLocationURI());
                    ((AbstractPropertiesHolder)info).addExtensor(httpAdd);
                    return info;
                }
                if (!(extensor instanceof AddressType)) continue;
                AddressType httpAdd = (AddressType)extensor;
                HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                ((EndpointInfo)info).setAddress(httpAdd.getLocation());
                ((AbstractPropertiesHolder)info).addExtensor(httpAdd);
                return info;
            }
        }
        HttpEndpointInfo hei = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
        HttpAddressType at = new HttpAddressType();
        hei.addExtensor(at);
        return hei;
    }

    @Override
    public void createPortExtensors(EndpointInfo ei, Service service) {
    }

    @Override
    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    protected void configure(Object bean) {
        this.configure(bean, null, null);
    }

    protected void configure(Object bean, String name, String extraName) {
        Configurer configurer = this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, bean);
            if (extraName != null) {
                configurer.configureBean(extraName, bean);
            }
        }
    }

    static HttpURLConnectionFactory getConnectionFactory(HTTPConduit configuredConduit) {
        return AbstractHTTPTransportFactory.getConnectionFactory(configuredConduit, null);
    }

    static HttpURLConnectionFactory getConnectionFactory(HTTPConduit configuredConduit, String address) {
        HttpURLConnectionFactory fac = null;
        boolean useHttps = false;
        if (address == null) {
            address = configuredConduit.getAddress();
        }
        if (address != null && address.startsWith("https:/")) {
            useHttps = true;
        }
        if (address == null) {
            boolean bl = useHttps = configuredConduit.getTlsClientParameters() != null;
        }
        if (useHttps) {
            TLSClientParameters params = configuredConduit.getTlsClientParameters();
            if (params == null) {
                params = new TLSClientParameters();
            }
            fac = new HttpsURLConnectionFactory(params);
        } else {
            fac = new HttpURLConnectionFactoryImpl();
        }
        return fac;
    }

    static {
        URI_PREFIXES.add("http://");
        URI_PREFIXES.add("https://");
    }

    private static class HttpAddressType
    extends AddressType
    implements HTTPAddress,
    SOAPAddress {
        public HttpAddressType() {
            this.setElementType(new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address"));
        }

        public String getLocationURI() {
            return this.getLocation();
        }

        public void setLocationURI(String locationURI) {
            this.setLocation(locationURI);
        }
    }

    private static class HttpEndpointInfo
    extends EndpointInfo {
        AddressType saddress;

        HttpEndpointInfo(ServiceInfo serv, String trans) {
            super(serv, trans);
        }

        public void setAddress(String s) {
            super.setAddress(s);
            if (this.saddress != null) {
                this.saddress.setLocation(s);
            }
        }

        public void addExtensor(Object el) {
            super.addExtensor(el);
            if (el instanceof AddressType) {
                this.saddress = (AddressType)el;
            }
        }
    }
}

