/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.javascript;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.wsdlto.javascript.JavaScriptContainer;

public class WSDLToJavaScript {
    private String[] args;

    public WSDLToJavaScript() {
        this.args = new String[0];
    }

    public WSDLToJavaScript(String[] pargs) {
        this.args = pargs;
    }

    private boolean isExitOnFinish() {
        String exit = System.getProperty("exitOnFinish");
        if (StringUtils.isEmpty(exit)) {
            return false;
        }
        return "YES".equalsIgnoreCase(exit) || "TRUE".equalsIgnoreCase(exit);
    }

    public void run(ToolContext context) throws Exception {
        if (this.args != null) {
            context.put("args", this.args);
        }
        InputStream toolspecStream = WSDLToJavaScript.getResourceAsStream(WSDLToJavaScript.class, "javascript-toolspec.xml");
        ToolRunner.runTool(JavaScriptContainer.class, toolspecStream, false, this.args, this.isExitOnFinish(), context);
    }

    protected boolean isVerbose() {
        return this.isSet(new String[]{"-V", "-verbose"});
    }

    private boolean isSet(String[] keys) {
        if (this.args == null) {
            return false;
        }
        List<String> pargs = Arrays.asList(this.args);
        for (String key : keys) {
            if (!pargs.contains(key)) continue;
            return true;
        }
        return false;
    }

    public void setArguments(String[] pargs) {
        this.args = pargs;
    }

    public static void main(String[] pargs) {
        WSDLToJavaScript w2j;
        block7: {
            CommandInterfaceUtils.commandCommonMain();
            w2j = new WSDLToJavaScript(pargs);
            try {
                w2j.run(new ToolContext());
            }
            catch (ToolException ex) {
                System.err.println();
                System.err.println("WSDLToJS Error : " + ex.getMessage());
                System.err.println();
                if (w2j.isVerbose()) {
                    ex.printStackTrace();
                }
                if (w2j.isExitOnFinish()) {
                    System.exit(1);
                }
            }
            catch (Exception ex) {
                System.err.println("WSDLToJS Error : " + ex.getMessage());
                System.err.println();
                if (w2j.isVerbose()) {
                    ex.printStackTrace();
                }
                if (!w2j.isExitOnFinish()) break block7;
                System.exit(1);
            }
        }
        if (w2j.isExitOnFinish()) {
            System.exit(0);
        }
    }

    private static InputStream getResourceAsStream(Class clz, String file) {
        return clz.getResourceAsStream(file);
    }
}

