/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWSS4JInterceptor
extends WSHandler
implements SoapInterceptor,
PhaseInterceptor<SoapMessage> {
    private static final Set<QName> HEADERS = new HashSet<QName>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    private String phase;
    private String id;
    private Map<String, Crypto> cryptoTable = new Hashtable<String, Crypto>();

    public AbstractWSS4JInterceptor() {
        this.id = this.getClass().getName();
    }

    @Override
    public Set<URI> getRoles() {
        return null;
    }

    @Override
    public void handleFault(SoapMessage message) {
    }

    public void postHandleMessage(SoapMessage message) throws Fault {
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public Object getOption(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getPassword(Object msgContext) {
        return (String)((Message)msgContext).getContextualProperty("password");
    }

    public Object getProperty(Object msgContext, String key) {
        Object obj = ((Message)msgContext).getContextualProperty(key);
        if (obj == null) {
            obj = this.getOption(key);
        }
        return obj;
    }

    public void setPassword(Object msgContext, String password) {
        ((Message)msgContext).put("password", password);
    }

    public void setProperty(Object msgContext, String key, Object value) {
        ((Message)msgContext).put(key, value);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Set<String> getAfter() {
        return this.after;
    }

    public void setAfter(Set<String> after) {
        this.after = after;
    }

    @Override
    public Set<String> getBefore() {
        return this.before;
    }

    public void setBefore(Set<String> before) {
        this.before = before;
    }

    protected boolean isRequestor(SoapMessage message) {
        return MessageUtils.isRequestor(message);
    }

    public Crypto loadSignatureCrypto(RequestData reqData) throws WSSecurityException {
        String refId;
        Crypto crypto = null;
        String sigPropFile = this.getString("signaturePropFile", reqData.getMsgContext());
        if (sigPropFile != null) {
            if (this.cryptoTable.get(sigPropFile) == null) {
                crypto = CryptoFactory.getInstance((String)sigPropFile, (ClassLoader)this.getClassLoader(reqData.getMsgContext()));
                this.cryptoTable.put(sigPropFile, crypto);
            } else {
                crypto = this.cryptoTable.get(sigPropFile);
            }
        } else if (this.getString("SignaturePropRefId", reqData.getMsgContext()) != null && (refId = this.getString("SignaturePropRefId", reqData.getMsgContext())) != null) {
            Object propObj = this.getProperty(reqData.getMsgContext(), refId);
            if (propObj instanceof Properties) {
                if (this.cryptoTable.get(refId) == null) {
                    crypto = CryptoFactory.getInstance((Properties)((Properties)propObj));
                    this.cryptoTable.put(refId, crypto);
                } else {
                    crypto = this.cryptoTable.get(refId);
                }
            } else {
                return crypto;
            }
        }
        return crypto;
    }

    protected Crypto loadDecryptionCrypto(RequestData reqData) throws WSSecurityException {
        String refId;
        Crypto crypto = null;
        String decPropFile = this.getString("decryptionPropFile", reqData.getMsgContext());
        if (decPropFile != null) {
            if (this.cryptoTable.get(decPropFile) == null) {
                crypto = CryptoFactory.getInstance((String)decPropFile, (ClassLoader)this.getClassLoader(reqData.getMsgContext()));
                this.cryptoTable.put(decPropFile, crypto);
            } else {
                crypto = this.cryptoTable.get(decPropFile);
            }
        } else if (this.getString("decryptionPropRefId", reqData.getMsgContext()) != null && (refId = this.getString("decryptionPropRefId", reqData.getMsgContext())) != null) {
            Object propObj = this.getProperty(reqData.getMsgContext(), refId);
            if (propObj instanceof Properties) {
                if (this.cryptoTable.get(refId) == null) {
                    crypto = CryptoFactory.getInstance((Properties)((Properties)propObj));
                    this.cryptoTable.put(refId, crypto);
                } else {
                    crypto = this.cryptoTable.get(refId);
                }
            } else {
                return crypto;
            }
        }
        return crypto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Crypto loadEncryptionCrypto(RequestData reqData) throws WSSecurityException {
        Crypto crypto = null;
        String encPropFile = this.getString("encryptionPropFile", reqData.getMsgContext());
        if (encPropFile != null) {
            if (this.cryptoTable.get(encPropFile) != null) return this.cryptoTable.get(encPropFile);
            crypto = CryptoFactory.getInstance((String)encPropFile, (ClassLoader)this.getClassLoader(reqData.getMsgContext()));
            this.cryptoTable.put(encPropFile, crypto);
            return crypto;
        } else if (this.getString("encryptionPropRefId", reqData.getMsgContext()) != null) {
            String refId = this.getString("encryptionPropRefId", reqData.getMsgContext());
            if (refId == null) return crypto;
            Object propObj = this.getProperty(reqData.getMsgContext(), refId);
            if (!(propObj instanceof Properties)) return crypto;
            if (this.cryptoTable.get(refId) != null) return this.cryptoTable.get(encPropFile);
            crypto = CryptoFactory.getInstance((Properties)((Properties)propObj));
            this.cryptoTable.put(refId, crypto);
            return crypto;
        } else {
            if (reqData.getSigCrypto() != null) return crypto;
            return crypto;
        }
    }

    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security"));
        HEADERS.add(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"));
    }
}

