/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResponseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResponseBuilderImpl
extends Response.ResponseBuilder {
    private int status = 200;
    private Object entity;
    private MultivaluedMap<String, Object> metadata = new MetadataMap<String, Object>();

    public ResponseBuilderImpl() {
    }

    private ResponseBuilderImpl(ResponseBuilderImpl copy) {
        this.status = copy.status;
        this.metadata.putAll(copy.metadata);
        this.entity = copy.entity;
    }

    public Response build() {
        ResponseImpl r = new ResponseImpl(this.status, this.entity);
        MetadataMap<String, Object> m = new MetadataMap<String, Object>();
        m.putAll((Map<String, List<Object>>)this.metadata);
        r.addMetadata(m);
        this.reset();
        return r;
    }

    public Response.ResponseBuilder status(int s) {
        this.status = s;
        return this;
    }

    public Response.ResponseBuilder entity(Object e) {
        this.entity = e;
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        return this.type(type.toString());
    }

    public Response.ResponseBuilder type(String type) {
        this.metadata.putSingle((Object)"Content-Type", (Object)type);
        return this;
    }

    public Response.ResponseBuilder language(String language) {
        this.metadata.putSingle((Object)"Content-Language", (Object)language.toString());
        return this;
    }

    public Response.ResponseBuilder location(URI location) {
        this.metadata.putSingle((Object)"Location", (Object)location.toString());
        return this;
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        this.metadata.putSingle((Object)"Content-Location", (Object)location.toString());
        return this;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        return this.tag(tag.toString());
    }

    public Response.ResponseBuilder tag(String tag) {
        this.metadata.putSingle((Object)"ETag", (Object)tag.toString());
        return this;
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        this.metadata.putSingle((Object)"Last-Modified", (Object)lastModified.toString());
        return this;
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        this.metadata.putSingle((Object)"Cache-Control", (Object)cacheControl.toString());
        return this;
    }

    public Response.ResponseBuilder cookie(NewCookie cookie) {
        this.metadata.putSingle((Object)"Set-Cookie", (Object)cookie.toString());
        return this;
    }

    public Response.ResponseBuilder expires(Date expires) {
        this.metadata.putSingle((Object)"Expires", (Object)expires.toString());
        return null;
    }

    public Response.ResponseBuilder language(Locale language) {
        this.metadata.putSingle((Object)"Content-Language", (Object)language.toString());
        return null;
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        for (NewCookie cookie : cookies) {
            this.metadata.add((Object)"Set-Cookie", (Object)cookie.toString());
        }
        return this;
    }

    public Response.ResponseBuilder header(String name, Object value) {
        this.metadata.add((Object)name, (Object)value.toString());
        return this;
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant.getMediaType() != null) {
            this.type(variant.getMediaType());
        }
        if (variant.getLanguage() != null) {
            this.language(variant.getLanguage());
        }
        if (variant.getEncoding() != null) {
            this.metadata.putSingle((Object)"Content-Encoding", (Object)variant.getEncoding());
        }
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        throw new UnsupportedOperationException("Only a single variant option is supported");
    }

    public Response.ResponseBuilder clone() {
        return new ResponseBuilderImpl(this);
    }

    private void reset() {
        this.metadata.clear();
        this.entity = null;
        this.status = 200;
    }
}

