/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ReadHeadersInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(ReadHeadersInterceptor.class);
    private Bus bus;

    public ReadHeadersInterceptor(Bus b) {
        super("read");
        this.bus = b;
    }

    public ReadHeadersInterceptor(Bus b, String phase) {
        super(phase);
        this.bus = b;
    }

    public void handleMessage(SoapMessage message) {
        if (this.isGET(message)) {
            LOG.fine("ReadHeadersInterceptor skipped in HTTP GET method");
            return;
        }
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        if (xmlReader == null) {
            InputStream in = message.getContent(InputStream.class);
            if (in == null) {
                throw new RuntimeException("Can't find input stream in message");
            }
            xmlReader = StaxUtils.createXMLStreamReader(in);
        }
        try {
            if (xmlReader.nextTag() == 1) {
                String ns = xmlReader.getNamespaceURI();
                if (ns == null || "".equals(ns)) {
                    throw new SoapFault(new Message("NO_NAMESPACE", LOG, xmlReader.getLocalName()), Soap11.getInstance().getVersionMismatch());
                }
                SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(ns);
                if (soapVersion == null) {
                    throw new SoapFault(new Message("INVALID_VERSION", LOG, ns, xmlReader.getLocalName()), Soap11.getInstance().getVersionMismatch());
                }
                message.setVersion(soapVersion);
                PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, message.getVersion().getBody());
                Document doc = StaxUtils.read(filteredReader);
                message.setContent(Node.class, doc);
                Element element = doc.getDocumentElement();
                QName header = soapVersion.getHeader();
                List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(element, header.getNamespaceURI(), header.getLocalPart());
                for (Element elem : elemList) {
                    Element hel = DOMUtils.getFirstElement(elem);
                    while (hel != null) {
                        Object obj;
                        if (elem.hasAttributes()) {
                            NamedNodeMap nnp = elem.getAttributes();
                            for (int ct = 0; ct < nnp.getLength(); ++ct) {
                                Node headerAttrNode;
                                Node attr = nnp.item(ct);
                                Node node = headerAttrNode = hel.hasAttributes() ? hel.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) : null;
                                if (headerAttrNode != null) continue;
                                Attr attribute = hel.getOwnerDocument().createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                                attribute.setNodeValue(attr.getNodeValue());
                                hel.setAttributeNodeNS(attribute);
                            }
                        }
                        HeaderProcessor p = this.bus.getExtension(HeaderManager.class).getHeaderProcessor(hel.getNamespaceURI());
                        DataBinding dataBinding = null;
                        if (p == null || p.getDataBinding() == null) {
                            obj = hel;
                        } else {
                            dataBinding = p.getDataBinding();
                            obj = dataBinding.createReader(Node.class).read(hel);
                        }
                        SoapHeader shead = new SoapHeader(new QName(hel.getNamespaceURI(), hel.getLocalName()), obj, dataBinding);
                        String mu = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameMustUnderstand());
                        String act = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameRole());
                        if (!StringUtils.isEmpty(act)) {
                            shead.setActor(act);
                        }
                        shead.setMustUnderstand(Boolean.valueOf(mu) != false || "1".equals(mu));
                        shead.setDirection(Header.Direction.DIRECTION_IN);
                        message.getHeaders().add(shead);
                        hel = DOMUtils.getNextElement(hel);
                    }
                }
                int i = xmlReader.next();
                while (i == 13 || i == 10) {
                    i = xmlReader.next();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new Message("XML_STREAM_EXC", LOG, new Object[0]), (Throwable)e, message.getVersion().getSender());
        }
    }
}

