/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.runtime;

import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;

public class CorbaStreamReader
implements XMLStreamReader {
    private CorbaTypeEventProducer eventProducer;
    private int currentState;

    public CorbaStreamReader(CorbaTypeEventProducer evProducer) {
        this.eventProducer = evProducer;
        this.currentState = 7;
    }

    public QName getName() {
        return this.eventProducer.getName();
    }

    public char[] getTextCharacters() {
        return this.eventProducer.getText().toCharArray();
    }

    public int getEventType() {
        return this.currentState;
    }

    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    public String getNamespaceURI() {
        return this.getName().getNamespaceURI();
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.currentState == 7) {
            return true;
        }
        boolean hasNextEvent = this.eventProducer.hasNext();
        if (!hasNextEvent && this.currentState != 8) {
            this.currentState = 8;
            hasNextEvent = true;
        }
        return hasNextEvent;
    }

    public int next() throws XMLStreamException {
        if (this.currentState == 7) {
            this.currentState = 0;
            return 7;
        }
        this.hasNext();
        if (this.currentState != 8) {
            this.currentState = this.eventProducer.next();
        }
        return this.currentState;
    }

    public int getTextLength() {
        return this.eventProducer.getText().length();
    }

    public boolean isStartElement() {
        return this.currentState == 1;
    }

    public boolean isCharacters() {
        return this.currentState == 4;
    }

    public boolean isEndElement() {
        return this.currentState == 2;
    }

    public void close() throws XMLStreamException {
    }

    public int getAttributeCount() {
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null) {
            return currentAttributes.size();
        }
        return 0;
    }

    public String getAttributeLocalName(int arg0) {
        Attribute a;
        String ret = null;
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null && (a = currentAttributes.get(arg0)) != null) {
            ret = a.getName().getLocalPart();
        }
        return ret;
    }

    public QName getAttributeName(int arg0) {
        Attribute a;
        QName ret = null;
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null && (a = currentAttributes.get(arg0)) != null) {
            ret = a.getName();
        }
        return ret;
    }

    public String getAttributeNamespace(int arg0) {
        Attribute a;
        String ret = null;
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null && (a = currentAttributes.get(arg0)) != null) {
            ret = a.getName().getNamespaceURI();
        }
        return ret;
    }

    public String getAttributePrefix(int arg0) {
        return null;
    }

    public String getAttributeType(int arg0) {
        return "CDATA";
    }

    public String getAttributeValue(int arg0) {
        Attribute a;
        String ret = null;
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null && (a = currentAttributes.get(arg0)) != null) {
            ret = a.getValue();
        }
        return ret;
    }

    public String getAttributeValue(String arg0, String arg1) {
        return null;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getElementText() throws XMLStreamException {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public Location getLocation() {
        return new Location(){

            public int getCharacterOffset() {
                return -1;
            }

            public int getColumnNumber() {
                return -1;
            }

            public int getLineNumber() {
                return -1;
            }

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }
        };
    }

    public NamespaceContext getNamespaceContext() {
        return null;
    }

    public int getNamespaceCount() {
        List<Namespace> namespaces = this.eventProducer.getNamespaces();
        if (namespaces != null) {
            return namespaces.size();
        }
        return 0;
    }

    public String getNamespacePrefix(int arg0) {
        List<Namespace> namespaces = this.eventProducer.getNamespaces();
        if (namespaces == null) {
            return null;
        }
        Namespace ns = namespaces.get(arg0);
        if (ns != null) {
            return ns.getPrefix();
        }
        return null;
    }

    public String getNamespaceURI(String arg0) {
        return null;
    }

    public String getNamespaceURI(int arg0) {
        List<Namespace> namespaces = this.eventProducer.getNamespaces();
        if (namespaces == null) {
            return null;
        }
        Namespace ns = namespaces.get(arg0);
        if (ns != null) {
            return ns.getNamespaceURI();
        }
        return null;
    }

    public String getPIData() {
        return null;
    }

    public String getPITarget() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        return null;
    }

    public String getText() {
        return this.eventProducer.getText();
    }

    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        throw new RuntimeException("Not implemented");
    }

    public int getTextStart() {
        return 0;
    }

    public String getVersion() {
        return null;
    }

    public boolean hasName() {
        throw new RuntimeException("Not Implemented");
    }

    public boolean hasText() {
        throw new RuntimeException("Not implemented");
    }

    public boolean isAttributeSpecified(int arg0) {
        return false;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean isWhiteSpace() {
        return false;
    }

    public int nextTag() throws XMLStreamException {
        throw new RuntimeException("Not Implemented");
    }

    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
    }

    public boolean standaloneSet() {
        return false;
    }
}

