/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.JaxwsClientCallback;
import org.apache.cxf.jaxws.JaxwsResponseCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor;
import org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchImpl<T>
implements Dispatch<T>,
BindingProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchImpl.class);
    private static final String DISPATCH_NS = "http://cxf.apache.org/jaxws/dispatch";
    private static final String INVOKE_NAME = "Invoke";
    private static final String INVOKE_ONEWAY_NAME = "InvokeOneWay";
    private final Binding binding;
    private final EndpointReferenceBuilder builder;
    private final Client client;
    private final Class<T> cl;
    private final JAXBContext context;
    private Message error;

    DispatchImpl(Client client, Service.Mode m, JAXBContext ctx, Class<T> clazz) {
        this.binding = ((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding();
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)client.getEndpoint());
        this.client = client;
        this.context = ctx;
        this.cl = clazz;
        this.setupEndpointAddressContext(client.getEndpoint());
        this.addInvokeOperation(false);
        this.addInvokeOperation(true);
        if (m == Service.Mode.MESSAGE && this.binding instanceof SOAPBinding) {
            if (DataSource.class.isAssignableFrom(clazz)) {
                this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, "DataSource", m, "SOAP/HTTP");
            } else if (m == Service.Mode.MESSAGE) {
                SAAJOutInterceptor saajOut = new SAAJOutInterceptor();
                client.getOutInterceptors().add(saajOut);
                client.getOutInterceptors().add(new MessageModeOutInterceptor(saajOut, client.getEndpoint().getBinding().getBindingInfo().getName()));
                client.getInInterceptors().add(new SAAJInInterceptor());
                client.getInInterceptors().add(new MessageModeInInterceptor(clazz, client.getEndpoint().getBinding().getBindingInfo().getName()));
            }
        } else if (m == Service.Mode.PAYLOAD && this.binding instanceof SOAPBinding && SOAPMessage.class.isAssignableFrom(clazz)) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, "SOAPMessage", m, "SOAP/HTTP");
        } else if (DataSource.class.isAssignableFrom(clazz) && this.binding instanceof HTTPBinding) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, "DataSource", m, "XML/HTTP");
        }
    }

    DispatchImpl(Client cl, Service.Mode m, Class<T> clazz) {
        this(cl, m, null, clazz);
    }

    private void addInvokeOperation(boolean oneWay) {
        String name = oneWay ? INVOKE_ONEWAY_NAME : INVOKE_NAME;
        ServiceInfo info = this.client.getEndpoint().getEndpointInfo().getService();
        OperationInfo opInfo = info.getInterface().addOperation(new QName(DISPATCH_NS, name));
        MessageInfo mInfo = opInfo.createMessage(new QName(DISPATCH_NS, name + "Request"), MessageInfo.Type.INPUT);
        opInfo.setInput(name + "Request", mInfo);
        MessagePartInfo mpi = mInfo.addMessagePart("parameters");
        if (this.context == null) {
            mpi.setTypeClass(this.cl);
        }
        mpi.setElement(true);
        if (!oneWay) {
            mInfo = opInfo.createMessage(new QName(DISPATCH_NS, name + "Response"), MessageInfo.Type.OUTPUT);
            opInfo.setOutput(name + "Response", mInfo);
            mpi = mInfo.addMessagePart("parameters");
            mpi.setElement(true);
            if (this.context == null) {
                mpi.setTypeClass(this.cl);
            }
        }
        for (BindingInfo bind : this.client.getEndpoint().getEndpointInfo().getService().getBindings()) {
            BindingOperationInfo bo = new BindingOperationInfo(bind, opInfo);
            bind.addOperation(bo);
        }
    }

    public Map<String, Object> getRequestContext() {
        return new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Map<String, Object> getResponseContext() {
        return new WrappedMessageContext(this.client.getResponseContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public EndpointReference getEndpointReference() {
        return this.builder.getEndpointReference();
    }

    public <X extends EndpointReference> X getEndpointReference(Class<X> clazz) {
        return this.builder.getEndpointReference(clazz);
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            WrappedMessageContext requestContext = new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
            requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    public T invoke(T obj) {
        return this.invoke(obj, false);
    }

    private void checkError() {
        if (this.error != null) {
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = null;
                try {
                    soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), new Exception(this.error.toString()));
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
                if (soapFault != null) {
                    throw new SOAPFaultException(soapFault);
                }
            } else if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)new Exception(this.error.toString()));
                throw exception;
            }
            throw new WebServiceException(this.error.toString());
        }
    }

    private RuntimeException mapException(Exception ex) {
        if (this.getBinding() instanceof HTTPBinding) {
            HTTPException exception = new HTTPException(500);
            exception.initCause((Throwable)ex);
            return exception;
        }
        if (this.getBinding() instanceof SOAPBinding) {
            SOAPFault soapFault = null;
            try {
                soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), ex);
            }
            catch (SOAPException e) {
                // empty catch block
            }
            if (soapFault == null) {
                return new WebServiceException((Throwable)ex);
            }
            SOAPFaultException exception = new SOAPFaultException(soapFault);
            exception.initCause((Throwable)ex);
            return exception;
        }
        return new WebServiceException((Throwable)ex);
    }

    public T invoke(T obj, boolean isOneWay) {
        this.checkError();
        try {
            QName opName;
            SOAPMessage msg;
            if (obj instanceof SOAPMessage && (msg = (SOAPMessage)obj).countAttachments() > 0) {
                this.client.getRequestContext().put("write.attachments", Boolean.TRUE);
            }
            if ((opName = (QName)this.getRequestContext().get("javax.xml.ws.wsdl.operation")) == null) {
                opName = new QName(DISPATCH_NS, isOneWay ? INVOKE_ONEWAY_NAME : INVOKE_NAME);
            }
            Object[] ret = this.client.invokeWrapped(opName, obj);
            if (isOneWay) {
                return null;
            }
            return (T)ret[0];
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public Future<?> invokeAsync(T obj, AsyncHandler<T> asyncHandler) {
        this.checkError();
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        JaxwsClientCallback<T> callback = new JaxwsClientCallback<T>(asyncHandler);
        JaxwsResponseCallback ret = new JaxwsResponseCallback(callback);
        try {
            QName opName = (QName)this.getRequestContext().get("javax.xml.ws.wsdl.operation");
            if (opName == null) {
                opName = new QName(DISPATCH_NS, INVOKE_NAME);
            }
            this.client.invokeWrapped(callback, opName, obj);
            return ret;
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public Response<T> invokeAsync(T obj) {
        return (Response)this.invokeAsync(obj, null);
    }

    public void invokeOneWay(T obj) {
        this.invoke(obj, true);
    }

    public Client getClient() {
        return this.client;
    }
}

