/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.util.Map;
import org.apache.cxf.BusException;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;

public class ClientFactoryBean
extends AbstractWSDLBasedEndpointFactory {
    private Client client;

    public ClientFactoryBean() {
        this(new ReflectionServiceFactoryBean());
    }

    public ClientFactoryBean(ReflectionServiceFactoryBean factory) {
        super(factory);
    }

    public Client create() {
        if (this.client != null) {
            return this.client;
        }
        this.applyExtraClass();
        try {
            Endpoint ep = this.createEndpoint();
            this.applyProperties(ep);
            this.createClient(ep);
            this.initializeAnnotationInterceptors(ep, this.getServiceClass());
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException(e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException(e);
        }
        this.applyFeatures();
        return this.client;
    }

    protected void createClient(Endpoint ep) {
        this.client = new ClientImpl(this.getBus(), ep, this.getConduitSelector());
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.client, this.getBus());
            }
        }
    }

    protected void applyExtraClass() {
        Map<String, Object> props = this.getProperties();
        if (props != null && props.get("jaxb.additionalContextClasses") != null) {
            Class[] extraClass = (Class[])this.getProperties().get("jaxb.additionalContextClasses");
            DataBinding dataBinding = this.getServiceFactory().getDataBinding();
            if (dataBinding instanceof JAXBDataBinding) {
                ((JAXBDataBinding)dataBinding).setExtraClass(extraClass);
            }
        }
    }

    protected void applyProperties(Endpoint ep) {
        Map<String, Object> props = this.getProperties();
        if (props != null && props.get(AuthorizationPolicy.class.getName()) != null) {
            AuthorizationPolicy ap = (AuthorizationPolicy)props.get(AuthorizationPolicy.class.getName());
            ep.getEndpointInfo().addExtensor(ap);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

