/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.math.BigInteger;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;

public abstract class AbstractSequence {
    protected final Identifier id;
    protected SequenceAcknowledgement acknowledgement;

    protected AbstractSequence(Identifier i) {
        this.id = i;
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public String toString() {
        return this.id.getValue();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AbstractSequence) {
            AbstractSequence otherSeq = (AbstractSequence)other;
            return otherSeq.getIdentifier().getValue().equals(this.getIdentifier().getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getIdentifier().getValue().hashCode();
    }

    public static boolean identifierEquals(Identifier id1, Identifier id2) {
        if (null == id1) {
            return null == id2;
        }
        return null != id2 && id1.getValue().equals(id2.getValue());
    }

    public synchronized boolean isAcknowledged(BigInteger m) {
        for (SequenceAcknowledgement.AcknowledgementRange r : this.acknowledgement.getAcknowledgementRange()) {
            if (m.subtract(r.getLower()).signum() < 0 || r.getUpper().subtract(m).signum() < 0) continue;
            return true;
        }
        return false;
    }
}

