/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
@Provider
public class JAXBElementProvider
extends AbstractJAXBProvider {
    private Map<String, Object> mProperties = new HashMap<String, Object>();
    private boolean enableStreaming;

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    public void setEnableStreaming(boolean enableStream) {
        this.enableStreaming = enableStream;
    }

    public boolean getEnableStreaming() {
        return this.enableStreaming;
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSchemas(List<String> locations) {
        super.setSchemaLocations(locations);
    }

    public void setSchemaHandler(SchemaHandler handler) {
        super.setSchema(handler.getSchema());
    }

    public void setMarshallerProperties(Map<String, Object> marshallProperties) {
        this.mProperties = marshallProperties;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.mProperties.put("jaxb.schemaLocation", schemaLocation);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            Class<?> theType = this.getActualType(type, genericType, anns);
            Unmarshaller unmarshaller = this.createUnmarshaller(theType, genericType);
            Object response = null;
            response = JAXBElement.class.isAssignableFrom(type) ? unmarshaller.unmarshal((Source)new StreamSource(is), theType) : unmarshaller.unmarshal(is);
            response = this.checkAdapter(response, anns, false);
            return response;
        }
        catch (JAXBException e) {
            JAXBElementProvider.handleJAXBException(e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return null;
    }

    public void writeTo(Object obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            Object actualObject = this.checkAdapter(obj, anns, true);
            Class<?> actualClass = actualObject.getClass();
            if (cls == genericType) {
                genericType = actualClass;
            }
            String encoding = this.getEncoding(m, headers);
            this.marshal(actualObject, actualClass, genericType, encoding, os);
        }
        catch (JAXBException e) {
            JAXBElementProvider.handleJAXBException(e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os) throws Exception {
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            ms.setProperty(entry.getKey(), entry.getValue());
        }
        if (this.enableStreaming) {
            XMLStreamWriter writer = (XMLStreamWriter)this.getContext().get(XMLStreamWriter.class.getName());
            if (writer == null) {
                writer = StaxUtils.createXMLStreamWriter(os);
            }
            ms.marshal(obj, writer);
        } else {
            ms.marshal(obj, os);
        }
    }
}

