/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private Set<String> encodings = new HashSet<String>();
    private Set<Locale> languages = new HashSet<Locale>();
    private Set<MediaType> mediaTypes = new HashSet<MediaType>();
    private List<Variant> variants = new ArrayList<Variant>();

    public Variant.VariantListBuilder add() {
        this.addVariants();
        this.resetMeta();
        return this;
    }

    public List<Variant> build() {
        ArrayList<Variant> vs = new ArrayList<Variant>(this.variants);
        this.reset();
        return vs;
    }

    public Variant.VariantListBuilder encodings(String ... encs) {
        this.encodings.addAll(Arrays.asList(encs));
        return this;
    }

    public Variant.VariantListBuilder mediaTypes(MediaType ... types) {
        this.mediaTypes.addAll(Arrays.asList(types));
        return this;
    }

    private void reset() {
        this.variants.clear();
        this.resetMeta();
    }

    private void resetMeta() {
        this.mediaTypes.clear();
        this.languages.clear();
        this.encodings.clear();
    }

    private void addVariants() {
        if (this.mediaTypes.size() > 0) {
            this.handleMediaTypes();
        } else if (this.languages.size() > 0) {
            this.handleLanguages(null);
        } else if (this.encodings.size() > 0) {
            for (String enc : this.encodings) {
                this.variants.add(new Variant(null, null, enc));
            }
        }
    }

    private void handleMediaTypes() {
        for (MediaType type : this.mediaTypes) {
            if (this.languages.size() > 0) {
                this.handleLanguages(type);
                continue;
            }
            if (this.encodings.size() > 0) {
                for (String enc : this.encodings) {
                    this.variants.add(new Variant(type, null, enc));
                }
                continue;
            }
            this.variants.add(new Variant(type, null, null));
        }
    }

    private void handleLanguages(MediaType type) {
        for (Locale lang : this.languages) {
            if (this.encodings.size() > 0) {
                for (String enc : this.encodings) {
                    this.variants.add(new Variant(type, lang, enc));
                }
                continue;
            }
            this.variants.add(new Variant(type, lang, null));
        }
    }

    public Variant.VariantListBuilder languages(Locale ... ls) {
        this.languages.addAll(Arrays.asList(ls));
        return this;
    }
}

