/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.EndpointImplFactory;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.endpoint.SimpleEndpointImplFactory;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.ClientOutFaultObserver;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
extends AbstractBasicInterceptorProvider
implements Client,
Retryable,
MessageObserver {
    public static final String THREAD_LOCAL_REQUEST_CONTEXT = "thread.local.request.context";
    public static final String FINISHED = "exchange.finished";
    private static final Logger LOG = LogUtils.getL7dLogger(ClientImpl.class);
    protected Bus bus;
    protected ConduitSelector conduitSelector;
    protected ClientOutFaultObserver outFaultObserver;
    protected int synchronousTimeout = 60000;
    protected PhaseChainCache outboundChainCache = new PhaseChainCache();
    protected PhaseChainCache inboundChainCache = new PhaseChainCache();
    protected Map<String, Object> currentRequestContext = new ConcurrentHashMap<String, Object>();
    protected ThreadLocal<EchoContext> requestContext = new ThreadLocal();
    protected ThreadLocal<Map<String, Object>> responseContext = new ThreadLocal();
    protected Executor executor;

    public ClientImpl(Bus b, Endpoint e) {
        this(b, e, (ConduitSelector)null);
    }

    public ClientImpl(Bus b, Endpoint e, Conduit c) {
        this(b, e, new PreexistingConduitSelector(c));
    }

    public ClientImpl(Bus b, Endpoint e, ConduitSelector sc) {
        this.bus = b;
        this.outFaultObserver = new ClientOutFaultObserver(this.bus);
        this.getConduitSelector(sc).setEndpoint(e);
        this.notifyLifecycleManager();
    }

    public ClientImpl(URL wsdlUrl) {
        this(BusFactory.getThreadDefaultBus(), wsdlUrl, null, null, SimpleEndpointImplFactory.getSingleton());
    }

    public ClientImpl(URL wsdlUrl, QName port) {
        this(BusFactory.getThreadDefaultBus(), wsdlUrl, null, port, SimpleEndpointImplFactory.getSingleton());
    }

    public ClientImpl(Bus bus, URL wsdlUrl, QName service, QName port) {
        this(bus, wsdlUrl, service, port, SimpleEndpointImplFactory.getSingleton());
    }

    public ClientImpl(Bus bus, URL wsdlUrl, QName service, QName port, EndpointImplFactory endpointImplFactory) {
        this.bus = bus;
        WSDLServiceFactory sf = service == null ? new WSDLServiceFactory(bus, wsdlUrl) : new WSDLServiceFactory(bus, wsdlUrl, service);
        Service svc = sf.create();
        EndpointInfo epfo = this.findEndpoint(svc, port);
        try {
            this.getConduitSelector().setEndpoint(new EndpointImpl(bus, svc, epfo));
        }
        catch (EndpointException epex) {
            throw new IllegalStateException("Unable to create endpoint: " + epex.getMessage(), epex);
        }
        this.notifyLifecycleManager();
    }

    @Override
    public void destroy() {
        ClientLifeCycleManager mgr = this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientDestroyed(this);
        }
    }

    private void notifyLifecycleManager() {
        ClientLifeCycleManager mgr = this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientCreated(this);
        }
    }

    private EndpointInfo findEndpoint(Service svc, QName port) {
        EndpointInfo epfo;
        if (port != null) {
            epfo = svc.getEndpointInfo(port);
            if (epfo == null) {
                throw new IllegalArgumentException("The service " + svc.getName() + " does not have an endpoint " + port + ".");
            }
        } else {
            epfo = null;
            for (ServiceInfo svcfo : svc.getServiceInfos()) {
                block1: for (EndpointInfo e : svcfo.getEndpoints()) {
                    BindingInfo bfo = e.getBinding();
                    if (!bfo.getBindingId().equals("http://schemas.xmlsoap.org/wsdl/soap/")) continue;
                    for (Object o : bfo.getExtensors().get()) {
                        SOAPBindingImpl soapB;
                        if (!(o instanceof SOAPBindingImpl) || !(soapB = (SOAPBindingImpl)o).getTransportURI().equals("http://schemas.xmlsoap.org/soap/http")) continue;
                        epfo = e;
                        continue block1;
                    }
                }
            }
            if (epfo == null) {
                throw new UnsupportedOperationException("Only document-style SOAP 1.1 http are supported for auto-selection of endpoint; none were found.");
            }
        }
        return epfo;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.getConduitSelector().getEndpoint();
    }

    @Override
    public Map<String, Object> getRequestContext() {
        if (this.isThreadLocalRequestContext()) {
            if (null == this.requestContext.get()) {
                this.requestContext.set(new EchoContext(this.currentRequestContext));
            }
            return this.requestContext.get();
        }
        return this.currentRequestContext;
    }

    @Override
    public Map<String, Object> getResponseContext() {
        if (null == this.responseContext.get()) {
            this.responseContext.set(new HashMap());
        }
        return this.responseContext.get();
    }

    @Override
    public boolean isThreadLocalRequestContext() {
        if (this.currentRequestContext.containsKey(THREAD_LOCAL_REQUEST_CONTEXT)) {
            Object o = this.currentRequestContext.get(THREAD_LOCAL_REQUEST_CONTEXT);
            boolean local = false;
            local = o instanceof Boolean ? (Boolean)o : Boolean.parseBoolean(o.toString());
            return local;
        }
        return false;
    }

    @Override
    public void setThreadLocalRequestContext(boolean b) {
        this.currentRequestContext.put(THREAD_LOCAL_REQUEST_CONTEXT, b);
    }

    @Override
    public Object[] invoke(BindingOperationInfo oi, Object ... params) throws Exception {
        return this.invoke(oi, params, (Exchange)null);
    }

    @Override
    public Object[] invoke(String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        return this.invoke(q, params);
    }

    @Override
    public Object[] invoke(QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, operationName));
        }
        if (op.isUnwrappedCapable()) {
            op = op.getUnwrappedOperation();
        }
        return this.invoke(op, params);
    }

    @Override
    public Object[] invokeWrapped(String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        return this.invokeWrapped(q, params);
    }

    @Override
    public Object[] invokeWrapped(QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, operationName));
        }
        return this.invoke(op, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] invoke(BindingOperationInfo oi, Object[] params, Exchange exchange) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<String, Object> resp = this.getResponseContext();
        resp.clear();
        HashMap<String, Object> req = new HashMap<String, Object>(this.getRequestContext());
        context.put("ResponseContext", resp);
        context.put("RequestContext", req);
        try {
            Object[] objectArray = this.invoke(oi, params, context, exchange);
            return objectArray;
        }
        finally {
            this.responseContext.set(resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context) throws Exception {
        try {
            Object[] objectArray = this.invoke(oi, params, context, null);
            return objectArray;
        }
        finally {
            Map resp;
            if (context != null && (resp = CastUtils.cast((Map)context.get("ResponseContext"))) != null) {
                this.responseContext.set(resp);
            }
        }
    }

    @Override
    public void invoke(ClientCallback callback, String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        this.invoke(callback, q, params);
    }

    @Override
    public void invoke(ClientCallback callback, QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, operationName));
        }
        if (op.isUnwrappedCapable()) {
            op = op.getUnwrappedOperation();
        }
        this.invoke(callback, op, params);
    }

    @Override
    public void invokeWrapped(ClientCallback callback, String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        this.invokeWrapped(callback, q, params);
    }

    @Override
    public void invokeWrapped(ClientCallback callback, QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, operationName));
        }
        this.invoke(callback, op, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ClientCallback callback, BindingOperationInfo oi, Object ... params) throws Exception {
        Bus origBus = BusFactory.getThreadDefaultBus(false);
        BusFactory.setThreadDefaultBus(this.bus);
        try {
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.setSynchronous(false);
            Endpoint endpoint = this.getEndpoint();
            HashMap<String, Map<String, Object>> context = new HashMap<String, Map<String, Object>>();
            Map<String, Object> resp = this.getResponseContext();
            resp.clear();
            HashMap<String, Object> reqContext = new HashMap<String, Object>(this.getRequestContext());
            context.put("ResponseContext", resp);
            context.put("RequestContext", reqContext);
            Message message = endpoint.getBinding().createMessage();
            message.put("org.apache.cxf.invocation.context", context);
            this.setContext(reqContext, message);
            this.setParameters(params, message);
            if (null != reqContext) {
                exchange.putAll(reqContext);
            }
            exchange.setOneWay(oi.getOutput() == null);
            exchange.setOutMessage(message);
            exchange.put(ClientCallback.class, callback);
            this.setOutMessageProperties(message, oi);
            this.setExchangeProperties(exchange, endpoint, oi);
            PhaseInterceptorChain chain = this.setupInterceptorChain(endpoint);
            message.setInterceptorChain(chain);
            this.modifyChain(chain, reqContext);
            chain.setFaultObserver(this.outFaultObserver);
            this.prepareConduitSelector(message);
            chain.doIntercept(message);
        }
        finally {
            BusFactory.setThreadDefaultBus(origBus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        Bus origBus = BusFactory.getThreadDefaultBus(false);
        BusFactory.setThreadDefaultBus(this.bus);
        try {
            if (exchange == null) {
                exchange = new ExchangeImpl();
            }
            exchange.setSynchronous(true);
            Endpoint endpoint = this.getEndpoint();
            Map<String, Object> reqContext = null;
            Map<String, Object> resContext = null;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Invoke, operation info: " + oi + ", params: " + params);
            }
            Message message = endpoint.getBinding().createMessage();
            if (null != context) {
                reqContext = CastUtils.cast((Map)context.get("RequestContext"));
                resContext = CastUtils.cast((Map)context.get("ResponseContext"));
                message.put("org.apache.cxf.invocation.context", context);
            }
            this.setContext(reqContext, message);
            this.setParameters(params, message);
            if (null != reqContext) {
                exchange.putAll(reqContext);
            }
            if (null != oi) {
                exchange.setOneWay(oi.getOutput() == null);
            }
            exchange.setOutMessage(message);
            this.setOutMessageProperties(message, oi);
            this.setExchangeProperties(exchange, endpoint, oi);
            PhaseInterceptorChain chain = this.setupInterceptorChain(endpoint);
            message.setInterceptorChain(chain);
            this.modifyChain(chain, reqContext);
            chain.setFaultObserver(this.outFaultObserver);
            this.prepareConduitSelector(message);
            chain.doIntercept(message);
            Object[] objectArray = this.processResult(message, exchange, oi, resContext);
            return objectArray;
        }
        finally {
            BusFactory.setThreadDefaultBus(origBus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] processResult(Message message, Exchange exchange, BindingOperationInfo oi, Map<String, Object> resContext) throws Exception {
        Boolean keepConduitAlive;
        Exception ex = message.getContent(Exception.class);
        boolean mepCompleteCalled = false;
        if (ex != null) {
            this.getConduitSelector().complete(exchange);
            mepCompleteCalled = true;
            if (message.getContent(Exception.class) != null) {
                throw ex;
            }
        }
        if ((ex = message.getExchange().get(Exception.class)) != null) {
            if (!mepCompleteCalled) {
                this.getConduitSelector().complete(exchange);
            }
            throw ex;
        }
        if (oi != null && !oi.getOperationInfo().isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                this.waitResponse(exchange);
            }
        }
        if ((keepConduitAlive = (Boolean)exchange.get("KeepConduitAlive")) == null || !keepConduitAlive.booleanValue()) {
            this.getConduitSelector().complete(exchange);
        }
        List resList = null;
        Message inMsg = exchange.getInMessage();
        if (inMsg != null) {
            if (null != resContext) {
                resContext.putAll(inMsg);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("set responseContext to be" + this.responseContext);
                }
            }
            resList = inMsg.getContent(List.class);
        }
        if ((ex = this.getException(exchange)) != null) {
            throw ex;
        }
        if (resList != null) {
            return resList.toArray();
        }
        return null;
    }

    protected Exception getException(Exchange exchange) {
        if (exchange.getInFaultMessage() != null) {
            return exchange.getInFaultMessage().getContent(Exception.class);
        }
        if (exchange.getOutFaultMessage() != null) {
            return exchange.getOutFaultMessage().getContent(Exception.class);
        }
        return null;
    }

    protected void setContext(Map<String, Object> ctx, Message message) {
        if (ctx != null) {
            message.putAll(ctx);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("set requestContext to message be" + ctx);
            }
        }
    }

    protected void waitResponse(Exchange exchange) {
        long start;
        long end;
        for (int remaining = this.synchronousTimeout; !Boolean.TRUE.equals(exchange.get(FINISHED)) && remaining > 0; remaining -= (int)(end - start)) {
            start = System.currentTimeMillis();
            try {
                exchange.wait(remaining);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            end = System.currentTimeMillis();
        }
        if (!Boolean.TRUE.equals(exchange.get(FINISHED))) {
            LogUtils.log(LOG, Level.WARNING, "RESPONSE_TIMEOUT", exchange.get(OperationInfo.class).getName().toString());
        }
    }

    protected void setParameters(Object[] params, Message message) {
        MessageContentsList contents = new MessageContentsList(params);
        message.setContent(List.class, contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message message) {
        Endpoint endpoint = message.getExchange().get(Endpoint.class);
        if (endpoint == null) {
            endpoint = this.getConduitSelector().getEndpoint();
            message.getExchange().put(Endpoint.class, endpoint);
        }
        message = endpoint.getBinding().createMessage(message);
        message.put("org.apache.cxf.client", Boolean.TRUE);
        message.put("org.apache.cxf.message.inbound", Boolean.TRUE);
        PhaseManager pm = this.bus.getExtension(PhaseManager.class);
        List<Interceptor> i1 = this.bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + i1);
        }
        List<Interceptor> i2 = this.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + i2);
        }
        List<Interceptor> i3 = endpoint.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + i2);
        }
        List<Interceptor> i4 = endpoint.getBinding().getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + i4);
        }
        PhaseInterceptorChain chain = this.inboundChainCache.get(pm.getInPhases(), i1, i2, i3, i4);
        message.setInterceptorChain(chain);
        chain.setFaultObserver(this.outFaultObserver);
        Bus origBus = BusFactory.getThreadDefaultBus(false);
        BusFactory.setThreadDefaultBus(this.bus);
        ClientCallback callback = message.getExchange().get(ClientCallback.class);
        try {
            if (callback != null) {
                if (callback.isCancelled()) {
                    this.getConduitSelector().complete(message.getExchange());
                    return;
                }
                callback.start(message);
            }
            String startingAfterInterceptorID = (String)message.get("starting_after_interceptor_id");
            String startingInterceptorID = (String)message.get("starting_at_interceptor_id");
            if (startingAfterInterceptorID != null) {
                chain.doInterceptStartingAfter(message, startingAfterInterceptorID);
            } else if (startingInterceptorID != null) {
                chain.doInterceptStartingAt(message, startingInterceptorID);
            } else {
                chain.doIntercept(message);
            }
            callback = message.getExchange().get(ClientCallback.class);
            if (callback != null && !this.isPartialResponse(message)) {
                message.getExchange().setInMessage(message);
                Map<String, Object> resCtx = CastUtils.cast((Map)message.getExchange().getOutMessage().get("org.apache.cxf.invocation.context"));
                resCtx = CastUtils.cast((Map)resCtx.get("ResponseContext"));
                try {
                    Object[] obj = this.processResult(message, message.getExchange(), null, resCtx);
                    callback.handleResponse(resCtx, obj);
                }
                catch (Throwable ex) {
                    callback.handleException(resCtx, ex);
                }
            }
        }
        finally {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                if (!this.isPartialResponse(message) && callback == null) {
                    message.getExchange().put(FINISHED, Boolean.TRUE);
                    message.getExchange().setInMessage(message);
                    message.getExchange().notifyAll();
                }
            }
            BusFactory.setThreadDefaultBus(origBus);
        }
    }

    @Override
    public Conduit getConduit() {
        MessageImpl message = new MessageImpl();
        ExchangeImpl exchange = new ExchangeImpl();
        message.setExchange(exchange);
        this.setExchangeProperties(exchange, null, null);
        return this.getConduitSelector().selectConduit(message);
    }

    protected void prepareConduitSelector(Message message) {
        this.getConduitSelector().prepare(message);
        message.getExchange().put(ConduitSelector.class, this.getConduitSelector());
    }

    protected void setOutMessageProperties(Message message, BindingOperationInfo boi) {
        message.put("org.apache.cxf.client", Boolean.TRUE);
        message.put("org.apache.cxf.message.inbound", Boolean.FALSE);
        if (null != boi) {
            message.put(BindingMessageInfo.class, boi.getInput());
            message.put(MessageInfo.class, boi.getOperationInfo().getInput());
        }
    }

    protected void setExchangeProperties(Exchange exchange, Endpoint endpoint, BindingOperationInfo boi) {
        if (endpoint != null) {
            exchange.put(Endpoint.class, endpoint);
            exchange.put(Service.class, endpoint.getService());
            if (endpoint.getEndpointInfo().getService() != null) {
                exchange.put(ServiceInfo.class, endpoint.getEndpointInfo().getService());
                exchange.put(InterfaceInfo.class, endpoint.getEndpointInfo().getService().getInterface());
            }
            exchange.put(Binding.class, endpoint.getBinding());
            exchange.put(BindingInfo.class, endpoint.getEndpointInfo().getBinding());
        }
        if (boi != null) {
            exchange.put(BindingOperationInfo.class, boi);
            exchange.put(OperationInfo.class, boi.getOperationInfo());
        }
        if (exchange.isSynchronous() || this.executor == null) {
            exchange.put(MessageObserver.class, this);
        } else {
            exchange.put(MessageObserver.class, new MessageObserver(){

                public void onMessage(final Message message) {
                    ClientImpl.this.executor.execute(new Runnable(){

                        public void run() {
                            ClientImpl.this.onMessage(message);
                        }
                    });
                }
            });
        }
        exchange.put(Retryable.class, this);
        exchange.put(Client.class, this);
        exchange.put(Bus.class, this.bus);
        if (endpoint != null && boi != null) {
            EndpointInfo endpointInfo = endpoint.getEndpointInfo();
            exchange.put("javax.xml.ws.wsdl.operation", boi.getName());
            QName serviceQName = endpointInfo.getService().getName();
            exchange.put("javax.xml.ws.wsdl.service", serviceQName);
            QName interfaceQName = endpointInfo.getService().getInterface().getName();
            exchange.put("javax.xml.ws.wsdl.interface", interfaceQName);
            QName portQName = endpointInfo.getName();
            exchange.put("javax.xml.ws.wsdl.port", portQName);
            URI wsdlDescription = endpointInfo.getProperty("URI", URI.class);
            if (wsdlDescription == null) {
                String address = endpointInfo.getAddress();
                try {
                    wsdlDescription = new URI(address + "?wsdl");
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                endpointInfo.setProperty("URI", wsdlDescription);
            }
            exchange.put("javax.xml.ws.wsdl.description", wsdlDescription);
        }
    }

    protected PhaseInterceptorChain setupInterceptorChain(Endpoint endpoint) {
        PhaseManager pm = this.bus.getExtension(PhaseManager.class);
        List<Interceptor> i1 = this.bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + i1);
        }
        List<Interceptor> i2 = this.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + i2);
        }
        List<Interceptor> i3 = endpoint.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + i3);
        }
        List<Interceptor> i4 = endpoint.getBinding().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + i4);
        }
        return this.outboundChainCache.get(pm.getOutPhases(), i1, i2, i3, i4);
    }

    protected void modifyChain(InterceptorChain chain, Map<String, Object> ctx) {
    }

    protected void setEndpoint(Endpoint e) {
        this.getConduitSelector().setEndpoint(e);
    }

    public int getSynchronousTimeout() {
        return this.synchronousTimeout;
    }

    public void setSynchronousTimeout(int synchronousTimeout) {
        this.synchronousTimeout = synchronousTimeout;
    }

    @Override
    public final ConduitSelector getConduitSelector() {
        return this.getConduitSelector(null);
    }

    protected final synchronized ConduitSelector getConduitSelector(ConduitSelector override) {
        if (null == this.conduitSelector) {
            this.setConduitSelector(override != null ? override : new UpfrontConduitSelector());
        }
        return this.conduitSelector;
    }

    @Override
    public final void setConduitSelector(ConduitSelector selector) {
        this.conduitSelector = selector;
    }

    private boolean isPartialResponse(Message in) {
        return Boolean.TRUE.equals(in.get("org.apache.cxf.partial.response"));
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EchoContext
    extends HashMap<String, Object> {
        final Map<String, Object> shared;

        public EchoContext(Map<String, Object> sharedMap) {
            super(sharedMap);
            this.shared = sharedMap;
        }

        @Override
        public Object put(String key, Object value) {
            this.shared.put(key, value);
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> t) {
            this.shared.putAll(t);
            super.putAll(t);
        }

        @Override
        public Object remove(Object key) {
            this.shared.remove(key);
            return super.remove(key);
        }

        public void reload() {
            super.clear();
            super.putAll(this.shared);
        }
    }
}

