/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNode {
    private String prefix;
    private QName name;
    private String attributeName;
    private String attributeValue;
    private XNode parentNode;
    private XNode failurePoint;
    private Map<String, String> nsMap = new HashMap<String, String>();

    public void setFailurePoint(XNode point) {
        this.failurePoint = point;
    }

    public XNode getFailurePoint() {
        return this.failurePoint;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newPrefix) {
        this.prefix = newPrefix;
    }

    public QName getQName() {
        return this.name;
    }

    public void setQName(QName newName) {
        this.name = newName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String newAttributeName) {
        this.attributeName = newAttributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String newAttributeValue) {
        this.attributeValue = newAttributeValue;
    }

    public XNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(XNode newParentNode) {
        this.parentNode = newParentNode;
    }

    public Map<String, String> getNSMap() {
        return this.nsMap;
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.name.getLocalPart());
        sb.append(":");
        sb.append(this.getAttributeValue());
        sb.append("]");
        return sb.toString();
    }

    public String getPlainText() {
        StringBuffer sb = new StringBuffer();
        Stack<XNode> parentNodes = this.getParentNodes();
        while (!parentNodes.empty()) {
            sb.append(parentNodes.pop().getText());
        }
        sb.append(this.getText());
        this.nsMap.put(this.prefix, this.name.getNamespaceURI());
        return sb.toString();
    }

    public String getXPath() {
        StringBuffer sb = new StringBuffer();
        sb.append("/");
        sb.append(this.prefix);
        sb.append(":");
        sb.append(this.name.getLocalPart());
        if (!StringUtils.isEmpty(this.attributeName) && !StringUtils.isEmpty(this.attributeValue)) {
            sb.append("[@");
            sb.append(this.attributeName);
            sb.append("='");
            sb.append(this.attributeValue);
            sb.append("']");
        }
        return sb.toString();
    }

    private Stack<XNode> getParentNodes() {
        Stack<XNode> parentNodes = new Stack<XNode>();
        for (XNode pNode = this.getParentNode(); pNode != null; pNode = pNode.getParentNode()) {
            this.nsMap.put(pNode.getPrefix(), pNode.getQName().getNamespaceURI());
            parentNodes.push(pNode);
        }
        return parentNodes;
    }

    public String toString() {
        Stack<XNode> parentNodes = this.getParentNodes();
        StringBuffer sb = new StringBuffer();
        while (!parentNodes.empty()) {
            sb.append(parentNodes.pop().getXPath());
        }
        sb.append(this.getXPath());
        this.nsMap.put(this.prefix, this.name.getNamespaceURI());
        return sb.toString();
    }
}

