/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedEncryptedParts
extends AbstractSecurityAssertion {
    private boolean body;
    private boolean attachments;
    private List<Header> headers = new ArrayList<Header>();
    private boolean signedParts;

    public SignedEncryptedParts(boolean signedParts, SPConstants version) {
        super(version);
        this.signedParts = signedParts;
    }

    public boolean isBody() {
        return this.body;
    }

    public void setBody(boolean body) {
        this.body = body;
    }

    public boolean isAttachments() {
        return this.attachments;
    }

    public void setAttachments(boolean attachments) {
        this.attachments = attachments;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public boolean isSignedParts() {
        return this.signedParts;
    }

    public QName getName() {
        if (this.signedParts) {
            return this.constants.getSignedParts();
        }
        return this.constants.getEncryptedParts();
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        if (this.isBody()) {
            writer.writeStartElement(prefix, "Body", namespaceURI);
            writer.writeEndElement();
        }
        for (Header header : this.headers) {
            writer.writeStartElement(prefix, "Header", namespaceURI);
            if (header.getName() != null) {
                writer.writeAttribute("Name", header.getName());
            }
            writer.writeAttribute("Namespace", header.getNamespace());
            writer.writeEndElement();
        }
        if (this.isAttachments() && this.constants.getVersion() == SPConstants.Version.SP_V12) {
            writer.writeStartElement(prefix, "Attachments", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

