/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestPreprocessor {
    private Map<Object, Object> languageMappings;
    private Map<Object, Object> extensionMappings;

    public RequestPreprocessor(Map<Object, Object> languageMappings, Map<Object, Object> extensionMappings) {
        this.languageMappings = languageMappings == null ? Collections.EMPTY_MAP : languageMappings;
        this.extensionMappings = extensionMappings == null ? Collections.EMPTY_MAP : extensionMappings;
    }

    public String preprocess(Message m, UriInfo u) {
        this.handleExtensionMappings(m, u);
        this.handleLanguageMappings(m, u);
        return new UriInfoImpl(m, null).getPath();
    }

    private void handleLanguageMappings(Message m, UriInfo uriInfo) {
        String path = uriInfo.getPath(false);
        for (Map.Entry<Object, Object> entry : this.languageMappings.entrySet()) {
            if (!path.endsWith("." + entry.getKey())) continue;
            this.updateAcceptLanguageHeader(m, entry.getValue().toString());
            this.updatePath(m, path, entry.getKey().toString());
            break;
        }
    }

    private void handleExtensionMappings(Message m, UriInfo uriInfo) {
        String path = uriInfo.getPath(false);
        for (Map.Entry<Object, Object> entry : this.extensionMappings.entrySet()) {
            if (!path.endsWith("." + entry.getKey().toString())) continue;
            this.updateAcceptTypeHeader(m, entry.getValue().toString());
            this.updatePath(m, path, entry.getKey().toString());
            break;
        }
    }

    private void updateAcceptTypeHeader(Message m, String anotherValue) {
        m.put("Accept", anotherValue);
    }

    private void updateAcceptLanguageHeader(Message m, String anotherValue) {
        ArrayList<String> acceptLanguage = (ArrayList<String>)((Map)m.get(Message.PROTOCOL_HEADERS)).get("Accept-Language");
        if (acceptLanguage == null) {
            acceptLanguage = new ArrayList<String>();
        }
        acceptLanguage.add(anotherValue);
        ((Map)m.get(Message.PROTOCOL_HEADERS)).put("Accept-Language", acceptLanguage);
    }

    private void updatePath(Message m, String path, String suffix) {
        String newPath = path.substring(0, path.length() - (suffix.length() + 1));
        HttpUtils.updatePath(m, newPath);
    }
}

