/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xmlbeans;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.xmlbeans.XmlBeansDataBinding;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReaderImpl
implements DataReader<XMLStreamReader> {
    private static final Logger LOG = LogUtils.getLogger(XmlBeansDataBinding.class);
    private boolean validate;

    @Override
    public Object read(XMLStreamReader input) {
        return this.read((MessagePartInfo)null, input);
    }

    @Override
    public Object read(MessagePartInfo part, XMLStreamReader reader) {
        Class<?> typeClass = part.getTypeClass();
        boolean unwrap = false;
        if (!XmlObject.class.isAssignableFrom(typeClass)) {
            typeClass = (Class<?>)part.getProperty(XmlAnySimpleType.class.getName());
            unwrap = true;
        }
        boolean isOutClass = false;
        Class<?> encClass = typeClass.getEnclosingClass();
        if (encClass != null) {
            typeClass = encClass;
            isOutClass = true;
        }
        Class<?>[] cls = typeClass.getDeclaredClasses();
        Object obj = null;
        for (Class<?> clazz : cls) {
            if (!"Factory".equals(clazz.getSimpleName())) continue;
            try {
                SchemaType st = (SchemaType)part.getProperty(SchemaType.class.getName());
                XmlOptions options = new XmlOptions();
                if (this.validate) {
                    options.setValidateOnSet();
                }
                if (st != null && !st.isDocumentType() && !isOutClass) {
                    options.setLoadReplaceDocumentElement(null);
                }
                Method meth = clazz.getMethod("parse", XMLStreamReader.class, XmlOptions.class);
                obj = meth.invoke(null, reader, options);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, part.getTypeClass()), (Throwable)e);
            }
        }
        if (unwrap && obj != null) {
            try {
                String methName;
                Class<?> tc = part.getTypeClass();
                if (tc.equals(Integer.TYPE) || tc.equals(Integer.class)) {
                    methName = "getIntValue";
                } else if (tc.equals(byte[].class)) {
                    methName = "byteArrayValue";
                } else {
                    String tp = tc.getSimpleName();
                    tp = Character.toUpperCase(tp.charAt(0)) + tp.substring(1);
                    methName = "get" + tp + "Value";
                }
                Method m = obj.getClass().getMethod(methName, new Class[0]);
                obj = m.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (isOutClass) {
            for (GenericDeclaration genericDeclaration : encClass.getDeclaredMethods()) {
                if (!((Method)genericDeclaration).getName().startsWith("get") || ((Method)genericDeclaration).getParameterTypes().length != 0 || !((Method)genericDeclaration).getReturnType().equals(part.getTypeClass())) continue;
                try {
                    obj = ((Method)genericDeclaration).invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (reader.getEventType() == 2) {
            try {
                reader.next();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    @Override
    public Object read(QName name, XMLStreamReader input, Class type) {
        return null;
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
    }

    @Override
    public void setProperty(String prop, Object value) {
    }

    @Override
    public void setSchema(Schema s) {
        this.validate = s != null;
    }

    public void setSchema(XmlSchemaCollection validationSchemas) {
        this.validate = validationSchemas != null;
    }
}

