/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.neethi.PolicyComponent;

public class Layout
extends AbstractSecurityAssertion {
    private String value = "Lax";

    public Layout(SPConstants version) {
        super(version);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if ("Lax".equals(value) || "Strict".equals(value) || "LaxTimestampFirst".equals(value) || "LaxTimestampLast".equals(value)) {
            this.value = value;
        }
    }

    public QName getName() {
        return this.constants.getLayout();
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeStartElement(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if ("Strict".equals(this.value)) {
            writer.writeStartElement(prefix, "Strict", namespaceURI);
        } else if ("Lax".equals(this.value)) {
            writer.writeStartElement(prefix, "Lax", namespaceURI);
        } else if ("LaxTimestampFirst".equals(this.value)) {
            writer.writeStartElement(prefix, "LaxTimestampFirst", namespaceURI);
        } else if ("LaxTimestampLast".equals(this.value)) {
            writer.writeStartElement(prefix, "LaxTimestampLast", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

