/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.continuations;

import java.util.Collection;
import org.apache.cxf.Bus;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.continuations.JMSContinuation;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSContinuationProvider
implements ContinuationProvider {
    private Bus bus;
    private Message inMessage;
    private MessageObserver incomingObserver;
    private Collection<JMSContinuation> continuations;
    private DefaultMessageListenerContainer jmsListener;
    private JMSConfiguration jmsConfig;

    public JMSContinuationProvider(Bus b, Message m, MessageObserver observer, Collection<JMSContinuation> cList, DefaultMessageListenerContainer jmsListener, JMSConfiguration jmsConfig) {
        this.bus = b;
        this.inMessage = m;
        this.incomingObserver = observer;
        this.continuations = cList;
        this.jmsListener = jmsListener;
        this.jmsConfig = jmsConfig;
    }

    @Override
    public Continuation getContinuation() {
        if (this.inMessage.getExchange().isOneWay()) {
            return null;
        }
        JMSContinuation cw = this.inMessage.get(JMSContinuation.class);
        if (cw == null) {
            cw = new JMSContinuation(this.bus, this.inMessage, this.incomingObserver, this.continuations, this.jmsListener, this.jmsConfig);
            this.inMessage.put(JMSContinuation.class, cw);
        }
        return cw;
    }
}

