/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilderImpl
extends UriBuilder {
    private boolean encode;
    private String scheme;
    private String userInfo;
    private int port;
    private String host;
    private List<PathSegment> paths;
    private String fragment;
    private MultivaluedMap<String, String> query = new MetadataMap<String, String>();
    private MultivaluedMap<String, String> matrix = new MetadataMap<String, String>();

    public UriBuilderImpl() {
    }

    public UriBuilderImpl(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
    }

    public URI build() throws UriBuilderException {
        return this.build(new Object[0]);
    }

    public URI build(Map<String, Object> map) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(map);
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        if (this.encode) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = HttpUtils.encodePartiallyEncoded(values[i].toString(), false);
            }
        }
        return this.doBuild(this.encode, values);
    }

    private URI doBuild(boolean fromEncoded, Object ... values) {
        try {
            String thePath = this.buildPath(fromEncoded);
            thePath = this.substituteVarargs(thePath, values);
            return this.buildURI(fromEncoded, thePath);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    private URI buildURI(boolean fromEncoded, String thePath) throws URISyntaxException {
        String theQuery = this.buildQuery(fromEncoded);
        if (fromEncoded) {
            StringBuilder b = new StringBuilder();
            b.append(this.scheme).append("://");
            if (this.userInfo != null) {
                b.append(this.userInfo).append('@');
            }
            b.append(this.host);
            if (this.port != -1) {
                b.append(':').append(this.port);
            }
            if (thePath != null && thePath.length() > 0) {
                b.append(thePath.startsWith("/") ? thePath : '/' + thePath);
            }
            if (theQuery != null && theQuery.length() != 0) {
                b.append('?').append(theQuery);
            }
            if (this.fragment != null) {
                b.append('#').append(this.fragment);
            }
            return new URI(b.toString());
        }
        return new URI(this.scheme, this.userInfo, this.host, this.port, thePath, theQuery, this.fragment);
    }

    private String substituteVarargs(String path, Object ... values) {
        HashMap<String, String> varValueMap = new HashMap<String, String>();
        URITemplate templ = new URITemplate(path);
        LinkedHashSet<String> uniqueVars = new LinkedHashSet<String>(templ.getVariables());
        if (values.length < uniqueVars.size()) {
            throw new IllegalArgumentException("Unresolved variables; only " + values.length + " value(s) given for " + uniqueVars.size() + " unique variable(s)");
        }
        int idx = 0;
        for (String var : uniqueVars) {
            Object oval = values[idx++];
            varValueMap.put(var, oval.toString());
        }
        return templ.substitute(varValueMap);
    }

    private URI buildFromMap(Map<String, ? extends Object> map) throws IllegalArgumentException, UriBuilderException {
        if (this.encode) {
            HashMap<String, String> decodedMap = new HashMap<String, String>(map.size());
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                decodedMap.put(entry.getKey(), HttpUtils.encodePartiallyEncoded(entry.getValue().toString(), false));
            }
            return this.doBuildFromMap(decodedMap, this.encode);
        }
        return this.doBuildFromMap(map, this.encode);
    }

    private URI doBuildFromMap(Map<String, ? extends Object> map, boolean fromEncoded) throws IllegalArgumentException, UriBuilderException {
        try {
            String thePath = this.buildPath(fromEncoded);
            thePath = this.substituteMapped(thePath, map);
            return this.buildURI(fromEncoded, thePath);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    private String substituteMapped(String path, Map<String, ? extends Object> varValueMap) {
        URITemplate templ = new URITemplate(path);
        HashSet<String> uniqueVars = new HashSet<String>(templ.getVariables());
        if (varValueMap.size() < uniqueVars.size()) {
            throw new IllegalArgumentException("Unresolved variables; only " + varValueMap.size() + " value(s) given for " + uniqueVars.size() + " unique variable(s)");
        }
        return templ.substitute(varValueMap);
    }

    public UriBuilder clone() {
        UriBuilderImpl builder = new UriBuilderImpl();
        builder.scheme = this.scheme;
        builder.userInfo = this.userInfo;
        builder.port = this.port;
        builder.host = this.host;
        builder.paths = new ArrayList<PathSegment>(this.paths);
        builder.fragment = this.fragment;
        builder.query = new MetadataMap<String, String>((Map<String, List<String>>)this.query);
        builder.matrix = new MetadataMap<String, String>((Map<String, List<String>>)this.matrix);
        builder.encode = this.encode;
        return builder;
    }

    public UriBuilder encode(boolean enable) {
        this.encode = enable;
        return this;
    }

    public UriBuilder fragment(String theFragment) throws IllegalArgumentException {
        this.fragment = theFragment;
        return this;
    }

    public UriBuilder host(String theHost) throws IllegalArgumentException {
        this.host = theHost;
        return this;
    }

    public UriBuilder matrixParam(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value != null) {
            this.matrix.add((Object)name, (Object)value);
        } else {
            this.matrix.remove((Object)name);
        }
        return this;
    }

    public UriBuilder path(String ... segments) throws IllegalArgumentException {
        if (this.paths == null) {
            this.paths = new ArrayList<PathSegment>();
        }
        for (String seg : segments) {
            this.paths.addAll(JAXRSUtils.getPathSegments(seg, false));
        }
        this.matrix.clear();
        if (!this.paths.isEmpty()) {
            this.matrix = this.paths.get(this.paths.size() - 1).getMatrixParameters();
        }
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        Path ann = resource.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Class '" + resource.getCanonicalName() + "' is not annotated with Path");
        }
        return this.path(ann.value());
    }

    public UriBuilder path(Method ... methods) throws IllegalArgumentException {
        if (methods == null) {
            throw new IllegalArgumentException("methods is null");
        }
        for (Method method : methods) {
            if (method == null) {
                throw new IllegalArgumentException("method is null");
            }
            Path ann = method.getAnnotation(Path.class);
            if (ann == null) {
                throw new IllegalArgumentException("Method '" + method.getClass().getCanonicalName() + "." + method.getName() + "' is not annotated with Path");
            }
            this.path(ann.value());
        }
        return this;
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path foundAnn = null;
        for (Method meth : resource.getMethods()) {
            if (!meth.getName().equals(method)) continue;
            Path ann = meth.getAnnotation(Path.class);
            if (foundAnn != null && ann != null) {
                throw new IllegalArgumentException("Multiple Path annotations for '" + method + "' overloaded method");
            }
            foundAnn = ann;
        }
        if (foundAnn == null) {
            throw new IllegalArgumentException("No Path annotation for '" + method + "' method");
        }
        return this.path(((Path)foundAnn).value());
    }

    public UriBuilder port(int thePort) throws IllegalArgumentException {
        this.port = thePort;
        return this;
    }

    public UriBuilder queryParam(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value != null) {
            this.query.add((Object)name, (Object)value);
        } else {
            this.query.remove((Object)name);
        }
        return this;
    }

    public UriBuilder replaceMatrixParams(String m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException("name is null");
        }
        MultivaluedMap<String, String> values = JAXRSUtils.getStructuredParams(m, ";", true);
        for (Map.Entry entry : values.entrySet()) {
            this.matrix.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public UriBuilder replaceQueryParams(String q) throws IllegalArgumentException {
        if (q == null) {
            throw new IllegalArgumentException("name is null");
        }
        MultivaluedMap<String, String> values = JAXRSUtils.getStructuredParams(q, "&", true);
        for (Map.Entry entry : values.entrySet()) {
            this.query.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public UriBuilder scheme(String s) throws IllegalArgumentException {
        this.scheme = s;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        try {
            if (this.scheme == null) {
                this.scheme = "http";
            }
            URI uri = new URI(this.scheme + "://" + ssp);
            this.setUriParts(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Wrong syntax of scheme-specific part", e);
        }
        return this;
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
        return this;
    }

    public UriBuilder userInfo(String ui) throws IllegalArgumentException {
        this.userInfo = ui;
        return this;
    }

    public boolean isEncode() {
        throw new UnsupportedOperationException("Not implemented :/");
    }

    public UriBuilder extension(String arg0) {
        throw new UnsupportedOperationException("Not implemented :/");
    }

    public UriBuilder replacePath(String ... path) throws IllegalArgumentException {
        for (String p : path) {
            this.paths = JAXRSUtils.getPathSegments(p, false);
        }
        if (!this.paths.isEmpty()) {
            this.matrix = this.paths.get(this.paths.size() - 1).getMatrixParameters();
        } else {
            this.matrix.clear();
        }
        return this;
    }

    private void setUriParts(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.scheme = uri.getScheme();
        this.port = uri.getPort();
        this.host = uri.getHost();
        this.setPathAndMatrix(uri.getRawPath());
        this.fragment = uri.getFragment();
        this.query = JAXRSUtils.getStructuredParams(uri.getRawQuery(), "&", false);
        this.userInfo = uri.getUserInfo();
    }

    private void setPathAndMatrix(String path) {
        this.paths = JAXRSUtils.getPathSegments(path, false, false);
        if (!this.paths.isEmpty()) {
            this.matrix = this.paths.get(this.paths.size() - 1).getMatrixParameters();
        } else {
            this.matrix.clear();
        }
    }

    private String buildPath(boolean fromEncoded) {
        StringBuilder sb = new StringBuilder();
        Iterator<PathSegment> iter = this.paths.iterator();
        while (iter.hasNext()) {
            PathSegment ps = iter.next();
            String p = ps.getPath();
            if (p.length() == 0 && iter.hasNext()) continue;
            String string = p = fromEncoded ? new URITemplate(p).encodeLiteralCharacters() : p;
            if (!p.startsWith("/")) {
                sb.append('/');
            }
            sb.append(p);
            if (!iter.hasNext()) continue;
            this.buildMatrix(sb, (MultivaluedMap<String, String>)ps.getMatrixParameters(), fromEncoded);
        }
        this.buildMatrix(sb, this.matrix, fromEncoded);
        return sb.toString();
    }

    private String buildQuery(boolean fromEncoded) {
        return this.buildParams(this.query, '&', fromEncoded);
    }

    private String buildParams(MultivaluedMap<String, String> map, char separator, boolean fromEncoded) {
        boolean isQuery = separator == '&';
        StringBuilder b = new StringBuilder();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Iterator sit = ((List)entry.getValue()).iterator();
            while (sit.hasNext()) {
                String val = (String)sit.next();
                if (fromEncoded) {
                    val = HttpUtils.encodePartiallyEncoded(val, isQuery);
                }
                b.append((String)entry.getKey()).append('=').append(val);
                if (!sit.hasNext() && !it.hasNext()) continue;
                b.append(separator);
            }
        }
        return b.length() > 0 ? b.toString() : null;
    }

    private void buildMatrix(StringBuilder sb, MultivaluedMap<String, String> map, boolean fromEncoded) {
        if (!map.isEmpty()) {
            sb.append(';');
            sb.append(this.buildParams(map, ';', fromEncoded));
        }
    }
}

