/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.lang.reflect.InvocationHandler;
import java.net.URI;
import java.util.List;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXRSClientFactory {
    private JAXRSClientFactory() {
    }

    public static <T> T create(String baseAddress, Class<T> cls) {
        return JAXRSClientFactory.create(URI.create(baseAddress), cls);
    }

    public static <T> T create(URI baseURI, Class<T> cls) {
        return JAXRSClientFactory.create(baseURI, cls, false);
    }

    public static <T> T create(URI baseURI, Class<T> cls, boolean inheritHeaders) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseURI.toString(), cls, null);
        bean.setInheritHeaders(inheritHeaders);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String configLocation, Object ... varValues) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        return bean.create(cls, varValues);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers) {
        return JAXRSClientFactory.create(baseAddress, cls, providers, null);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean.setProviders(providers);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T fromClient(Client client, Class<T> cls) {
        return JAXRSClientFactory.fromClient(client, cls, false);
    }

    public static <T> T fromClient(Client client, Class<T> cls, boolean inheritHeaders) {
        T proxy = JAXRSClientFactory.create(client.getCurrentURI(), cls, inheritHeaders);
        if (inheritHeaders) {
            WebClient.client(proxy).headers(client.getHeaders());
        }
        WebClient.copyProperties(WebClient.client(proxy), client);
        return proxy;
    }

    static <T> T create(Class<T> cls, InvocationHandler handler) {
        return cls.cast(ProxyHelper.getProxy(cls.getClassLoader(), new Class[]{cls, Client.class}, handler));
    }

    private static JAXRSClientFactoryBean getBean(String baseAddress, Class<?> cls, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setServiceClass(cls);
        return bean;
    }
}

