/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBEncoderDecoder {
    private static final Logger LOG = LogUtils.getLogger(JAXBEncoderDecoder.class);

    private JAXBEncoderDecoder() {
    }

    public static void marshall(Marshaller marshaller, Object elValue, MessagePartInfo part, Object source) {
        try {
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)false);
        }
        catch (PropertyException e) {
            // empty catch block
        }
        Class<?> cls = null;
        if (part != null) {
            cls = part.getTypeClass();
        }
        if (cls == null) {
            Class<?> clazz = cls = null != elValue ? elValue.getClass() : null;
        }
        if (cls != null && cls.isArray() && elValue instanceof Collection) {
            Collection col = (Collection)elValue;
            elValue = col.toArray((Object[])Array.newInstance(cls.getComponentType(), col.size()));
        }
        try {
            Object mObj = elValue;
            QName elName = null;
            if (part != null) {
                elName = part.getConcreteName();
            }
            if (null != elName) {
                if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
                    XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
                    if (mObj.getClass().isArray() && el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                        mObj = Arrays.asList(mObj);
                        JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, cls, mObj));
                    } else if (part.getMessageInfo().getOperation().isUnwrapped() && (mObj.getClass().isArray() || mObj instanceof List) && el.getMaxOccurs() != 1L) {
                        JAXBEncoderDecoder.writeArrayObject(marshaller, source, elName, mObj);
                    } else {
                        JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, cls, mObj));
                    }
                } else if (byte[].class == cls && part.getTypeQName() != null && part.getTypeQName().getLocalPart().equals("hexBinary")) {
                    mObj = new HexBinaryAdapter().marshal((byte[])mObj);
                    JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, String.class, mObj));
                } else if (mObj instanceof JAXBElement) {
                    JAXBEncoderDecoder.writeObject(marshaller, source, mObj);
                } else {
                    JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, cls, mObj));
                }
            } else {
                JAXBEncoderDecoder.writeObject(marshaller, source, mObj);
            }
        }
        catch (Fault ex) {
            throw (Fault)ex.fillInStackTrace();
        }
        catch (Exception ex) {
            if (ex instanceof MarshalException) {
                MarshalException marshalEx = (MarshalException)ex;
                Message faultMessage = new Message("MARSHAL_ERROR", LOG, marshalEx.getLinkedException().getMessage());
                throw new Fault(faultMessage, (Throwable)ex);
            }
            throw new Fault(new Message("MARSHAL_ERROR", LOG, ex.getMessage()), (Throwable)ex);
        }
    }

    public static void marshalWithBridge(QName qname, Class<?> cls, Annotation[] anns, Set<Class<?>> ctxClasses, Object elValue, Object source, AttachmentMarshaller am) {
        block6: {
            try {
                JAXBUtils.BridgeWrapper bridge = JAXBUtils.createBridge(ctxClasses, qname, cls, anns);
                if (source instanceof XMLStreamWriter) {
                    bridge.marshal(elValue, (XMLStreamWriter)source, am);
                    break block6;
                }
                if (source instanceof OutputStream) {
                    StringWriter sw = new StringWriter();
                    StreamResult s1 = new StreamResult(sw);
                    bridge.marshal(elValue, s1);
                    ((OutputStream)source).write(sw.toString().getBytes());
                    break block6;
                }
                if (source instanceof Node) {
                    bridge.marshal(elValue, (Node)source, am);
                    break block6;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (ex instanceof MarshalException) {
                    MarshalException marshalEx = (MarshalException)ex;
                    Message faultMessage = new Message("MARSHAL_ERROR", LOG, marshalEx.getLinkedException().getMessage());
                    throw new Fault(faultMessage, (Throwable)ex);
                }
                throw new Fault(new Message("MARSHAL_ERROR", LOG, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static Object unmarshalWithBridge(QName qname, Class<?> cls, Annotation[] anns, Set<Class<?>> ctxClasses, Object source, AttachmentUnmarshaller am) {
        try {
            JAXBUtils.BridgeWrapper bridge = JAXBUtils.createBridge(ctxClasses, qname, cls, anns);
            if (source instanceof XMLStreamReader) {
                return bridge.unmarshal((XMLStreamReader)source, am);
            }
            if (source instanceof InputStream) {
                return bridge.unmarshal((InputStream)source);
            }
            if (source instanceof Node) {
                return bridge.unmarshal((Node)source, am);
            }
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
        }
        catch (Exception ex) {
            if (ex instanceof MarshalException) {
                MarshalException marshalEx = (MarshalException)ex;
                Message faultMessage = new Message("MARSHAL_ERROR", LOG, marshalEx.getLinkedException().getMessage());
                throw new Fault(faultMessage, (Throwable)ex);
            }
            throw new Fault(new Message("MARSHAL_ERROR", LOG, ex.getMessage()), (Throwable)ex);
        }
    }

    public static void marshallException(Marshaller marshaller, Exception elValue, MessagePartInfo part, Object source) {
        XMLStreamWriter writer = JAXBEncoderDecoder.getStreamWriter(source);
        QName qn = part.getElementQName();
        try {
            writer.writeStartElement("ns1", qn.getLocalPart(), qn.getNamespaceURI());
            Class<?> cls = part.getTypeClass();
            XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
            if (accessorType == null && cls.getPackage() != null) {
                accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
            }
            XmlAccessType accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
            String namespace = part.getElementQName().getNamespaceURI();
            SchemaInfo sch = part.getMessageInfo().getOperation().getInterface().getService().getSchema(namespace);
            if (sch != null) {
                if (!sch.isElementFormQualified()) {
                    namespace = null;
                }
            } else {
                LOG.warning("Schema associated with " + namespace + " is null");
            }
            for (Field field : cls.getDeclaredFields()) {
                if (!JAXBContextInitializer.isFieldAccepted(field, accessType)) continue;
                QName fname = new QName(namespace, field.getName());
                field.setAccessible(true);
                if (JAXBSchemaInitializer.isArray(field.getGenericType())) {
                    JAXBEncoderDecoder.writeArrayObject(marshaller, writer, fname, field.get(elValue));
                    continue;
                }
                JAXBEncoderDecoder.writeObject(marshaller, writer, new JAXBElement(fname, String.class, field.get(elValue)));
            }
            for (AccessibleObject accessibleObject : cls.getMethods()) {
                if (!JAXBContextInitializer.isMethodAccepted((Method)accessibleObject, accessType)) continue;
                int idx = ((Method)accessibleObject).getName().startsWith("get") ? 3 : 2;
                String name = ((Method)accessibleObject).getName().substring(idx);
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                QName mname = new QName(namespace, name);
                if (JAXBSchemaInitializer.isArray(((Method)accessibleObject).getGenericReturnType())) {
                    JAXBEncoderDecoder.writeArrayObject(marshaller, writer, mname, ((Method)accessibleObject).invoke(elValue, new Object[0]));
                    continue;
                }
                JAXBEncoderDecoder.writeObject(marshaller, writer, new JAXBElement(mname, String.class, ((Method)accessibleObject).invoke(elValue, new Object[0])));
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (Exception e) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, e.getMessage()), (Throwable)e);
        }
    }

    private static void writeArrayObject(Marshaller marshaller, Object source, QName mname, Object mObj) throws Fault, JAXBException {
        Object[] objArray;
        if (mObj == null) {
            return;
        }
        Class<?> cls = null;
        if (mObj instanceof List) {
            List l = (List)mObj;
            objArray = l.toArray(new Object[l.size()]);
            cls = null;
        } else {
            objArray = mObj;
            cls = objArray.getClass().getComponentType();
        }
        int len = Array.getLength(objArray);
        for (int x = 0; x < len; ++x) {
            Object o = Array.get(objArray, x);
            JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(mname, cls == null ? o.getClass() : cls, o));
        }
    }

    public static Exception unmarshallException(Unmarshaller u, Object source, MessagePartInfo part) {
        XMLStreamReader reader;
        if (source instanceof XMLStreamReader) {
            reader = (XMLStreamReader)source;
        } else if (source instanceof Element) {
            reader = StaxUtils.createXMLStreamReader((Element)source);
            try {
                reader.nextTag();
            }
            catch (XMLStreamException e) {}
        } else {
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
        }
        try {
            QName qn = part.getElementQName();
            if (!qn.equals(reader.getName())) {
                throw new Fault(new Message("ELEMENT_NAME_MISMATCH", LOG, qn, reader.getName()));
            }
            Class<?> cls = part.getTypeClass();
            Object obj = null;
            try {
                Constructor<?> cons = cls.getConstructor(new Class[0]);
                obj = cons.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException nse) {
                Constructor<?> cons = cls.getConstructor(String.class);
                obj = cons.newInstance(new Object[1]);
            }
            XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
            if (accessorType == null && cls.getPackage() != null) {
                accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
            }
            XmlAccessType accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
            reader.nextTag();
            while (reader.getEventType() == 1) {
                QName q = reader.getName();
                try {
                    Field f = cls.getField(q.getLocalPart());
                    Type type = f.getGenericType();
                    if (!JAXBContextInitializer.isFieldAccepted(f, accessType)) continue;
                    f.setAccessible(true);
                    if (JAXBSchemaInitializer.isArray(type)) {
                        Class<?> compType = JAXBSchemaInitializer.getArrayComponentType(type);
                        List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, reader, q, compType, JAXBEncoderDecoder.createList(type));
                        Object[] o = ret;
                        if (!JAXBEncoderDecoder.isList(type)) {
                            if (compType.isPrimitive()) {
                                o = Array.newInstance(compType, ret.size());
                                for (int x = 0; x < ret.size(); ++x) {
                                    Array.set(o, x, ret.get(x));
                                }
                            } else {
                                o = ret.toArray((Object[])Array.newInstance(compType, ret.size()));
                            }
                        }
                        f.set(obj, o);
                        continue;
                    }
                    f.set(obj, u.unmarshal(reader, f.getType()));
                }
                catch (NoSuchFieldException ex) {
                    String s = Character.toUpperCase(q.getLocalPart().charAt(0)) + q.getLocalPart().substring(1);
                    Method m = null;
                    try {
                        m = cls.getMethod("get" + s, new Class[0]);
                    }
                    catch (NoSuchMethodException mex) {
                        m = cls.getMethod("is" + s, new Class[0]);
                    }
                    Type type = m.getGenericReturnType();
                    Method m2 = cls.getMethod("set" + s, m.getReturnType());
                    if (JAXBSchemaInitializer.isArray(type)) {
                        Class<?> compType = JAXBSchemaInitializer.getArrayComponentType(type);
                        List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, reader, q, compType, JAXBEncoderDecoder.createList(type));
                        Object[] o = ret;
                        if (!JAXBEncoderDecoder.isList(type)) {
                            if (compType.isPrimitive()) {
                                o = Array.newInstance(compType, ret.size());
                                for (int x = 0; x < ret.size(); ++x) {
                                    Array.set(o, x, ret.get(x));
                                }
                            } else {
                                o = ret.toArray((Object[])Array.newInstance(compType, ret.size()));
                            }
                        }
                        m2.invoke(obj, new Object[]{o});
                        continue;
                    }
                    Object o = JAXBEncoderDecoder.getElementValue(u.unmarshal(reader, m.getReturnType()));
                    m2.invoke(obj, o);
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, e.getMessage()), (Throwable)e);
        }
    }

    private static void writeObject(Marshaller u, Object source, Object mObj) throws Fault, JAXBException {
        if (source instanceof XMLStreamWriter) {
            u.marshal(mObj, (XMLStreamWriter)source);
        } else if (source instanceof OutputStream) {
            u.marshal(mObj, (OutputStream)source);
        } else if (source instanceof Node) {
            u.marshal(mObj, (Node)source);
        } else if (source instanceof XMLEventWriter) {
            u.marshal(mObj, (XMLEventWriter)source);
        } else {
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
        }
    }

    private static XMLStreamWriter getStreamWriter(Object source) throws Fault {
        if (source instanceof XMLStreamWriter) {
            return (XMLStreamWriter)source;
        }
        if (source instanceof OutputStream) {
            return StaxUtils.createXMLStreamWriter((OutputStream)source);
        }
        if (source instanceof Node) {
            return new W3CDOMStreamWriter((Element)source);
        }
        throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
    }

    public static void marshallNullElement(Marshaller marshaller, Object source, MessagePartInfo part) {
        Class<?> clazz = part != null ? part.getTypeClass() : null;
        try {
            JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(part.getElementQName(), clazz, null));
        }
        catch (JAXBException e) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, e.getMessage()), (Throwable)e);
        }
    }

    public static Object unmarshall(Unmarshaller u, Object source, MessagePartInfo part, boolean unwrap) {
        List<Object> o;
        QName elName;
        Class<?> clazz;
        Class<?> clazz2 = clazz = part != null ? part.getTypeClass() : null;
        if (clazz != null && Exception.class.isAssignableFrom(clazz) && part != null && Boolean.TRUE.equals(part.getProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION"))) {
            return JAXBEncoderDecoder.unmarshallException(u, source, part);
        }
        QName qName = elName = part != null ? part.getConcreteName() : null;
        if (clazz != null && clazz.isArray() && part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
            if (el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                Object obj = JAXBEncoderDecoder.unmarshall(u, source, elName, null, unwrap);
                if (clazz.isArray() && obj instanceof List) {
                    return ((List)obj).toArray((Object[])Array.newInstance(clazz.getComponentType(), ((List)obj).size()));
                }
                return obj;
            }
            if (part.getMessageInfo().getOperation().isUnwrapped() && el.getMaxOccurs() != 1L) {
                List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, source, elName, clazz.getComponentType(), JAXBEncoderDecoder.createList(part));
                Object[] o2 = ret;
                if (!JAXBEncoderDecoder.isList(part)) {
                    if (clazz.getComponentType().isPrimitive()) {
                        o2 = Array.newInstance(clazz.getComponentType(), ret.size());
                        for (int x = 0; x < ret.size(); ++x) {
                            Array.set(o2, x, ret.get(x));
                        }
                    } else {
                        o2 = ret.toArray((Object[])Array.newInstance(clazz.getComponentType(), ret.size()));
                    }
                }
                return o2;
            }
        } else if (byte[].class == clazz && part != null && part.getTypeQName() != null && part.getTypeQName().getLocalPart().equals("hexBinary")) {
            String obj = (String)JAXBEncoderDecoder.unmarshall(u, source, elName, String.class, unwrap);
            return new HexBinaryAdapter().unmarshal(obj);
        }
        if ((o = JAXBEncoderDecoder.unmarshall(u, source, elName, clazz, unwrap)) != null && o.getClass().isArray() && JAXBEncoderDecoder.isList(part)) {
            List<Object> ret = JAXBEncoderDecoder.createList(part);
            ret.addAll(Arrays.asList((Object[])o));
            o = ret;
        }
        return o;
    }

    private static List<Object> createList(MessagePartInfo part) {
        Type genericType = (Type)part.getProperty("generic.type");
        return JAXBEncoderDecoder.createList(genericType);
    }

    private static List<Object> createList(Type genericType) {
        Class cls;
        Type tp2;
        if (genericType instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class && !(cls = (Class)tp2).isInterface() && List.class.isAssignableFrom(cls)) {
            try {
                return CastUtils.cast((List)cls.newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<Object>();
    }

    private static boolean isList(Type cls) {
        return cls instanceof ParameterizedType;
    }

    private static boolean isList(MessagePartInfo part) {
        Type tp2;
        Type genericType;
        if (part.getTypeClass().isArray() && !part.getTypeClass().getComponentType().isPrimitive() && (genericType = (Type)part.getProperty("generic.type")) instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class) {
            return Collection.class.isAssignableFrom((Class)tp2);
        }
        return false;
    }

    public static Object unmarshall(Unmarshaller u, Object source, QName elName, Class<?> clazz, boolean unwrap) {
        Object obj;
        block10: {
            obj = null;
            try {
                boolean unmarshalWithClass = true;
                if (clazz == null || !clazz.isPrimitive() && !clazz.isArray() && !clazz.isEnum() && !clazz.equals(Calendar.class) && (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()))) {
                    unmarshalWithClass = false;
                }
                if (clazz != null && (clazz.getName().equals("javax.xml.datatype.XMLGregorianCalendar") || clazz.getName().equals("javax.xml.datatype.Duration"))) {
                    unmarshalWithClass = true;
                }
                if (source instanceof Node) {
                    obj = unmarshalWithClass ? u.unmarshal((Node)source, clazz) : u.unmarshal((Node)source);
                    break block10;
                }
                if (source instanceof XMLStreamReader) {
                    obj = unmarshalWithClass ? u.unmarshal((XMLStreamReader)source, clazz) : u.unmarshal((XMLStreamReader)source);
                    break block10;
                }
                if (source instanceof XMLEventReader) {
                    obj = unmarshalWithClass ? u.unmarshal((XMLEventReader)source, clazz) : u.unmarshal((XMLEventReader)source);
                    break block10;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
            }
            catch (Fault ex) {
                ex.fillInStackTrace();
                throw ex;
            }
            catch (Throwable ex) {
                if (ex instanceof UnmarshalException) {
                    UnmarshalException unmarshalEx = (UnmarshalException)ex;
                    if (unmarshalEx.getLinkedException() != null) {
                        throw new Fault(new Message("UNMARSHAL_ERROR", LOG, unmarshalEx.getLinkedException().getMessage()), ex);
                    }
                    throw new Fault(new Message("UNMARSHAL_ERROR", LOG, unmarshalEx.getMessage()), ex);
                }
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, ex.getMessage()), ex);
            }
        }
        return unwrap ? JAXBEncoderDecoder.getElementValue(obj) : obj;
    }

    public static Object getElementValue(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    public static Class<?> getClassFromType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)t;
            return Array.newInstance(JAXBEncoderDecoder.getClassFromType(g.getGenericComponentType()), 0).getClass();
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            return JAXBEncoderDecoder.getClassFromType(p.getRawType());
        }
        assert (false);
        throw new IllegalArgumentException("Cannot get Class object from unknown Type");
    }

    public static List<Object> unmarshallArray(Unmarshaller u, Object source, QName elName, Class<?> clazz, List<Object> ret) {
        try {
            XMLStreamReader reader;
            if (source instanceof XMLStreamReader) {
                reader = (XMLStreamReader)source;
            } else if (source instanceof Element) {
                reader = StaxUtils.createXMLStreamReader((Element)source);
            } else {
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
            }
            while (reader.getName().equals(elName)) {
                Object obj = u.unmarshal(reader, clazz);
                if (obj instanceof JAXBElement) {
                    obj = obj.getValue();
                }
                ret.add(obj);
                while (reader.getEventType() != 1 && reader.getEventType() != 2) {
                    reader.nextTag();
                }
            }
            return ret;
        }
        catch (Fault ex) {
            ex.fillInStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof UnmarshalException) {
                UnmarshalException unmarshalEx = (UnmarshalException)ex;
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, unmarshalEx.getLinkedException().getMessage()), (Throwable)ex);
            }
            throw new Fault(new Message("UNMARSHAL_ERROR", LOG, ex.getMessage()), (Throwable)ex);
        }
    }
}

