/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.util.date.XsDateTimeFormat;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;

public class TimestampType
extends Type {
    private static XsDateTimeFormat format = new XsDateTimeFormat();

    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        String value = reader.getValue();
        if (value == null) {
            return null;
        }
        try {
            Calendar c = (Calendar)format.parseObject(value.trim());
            return new Timestamp(c.getTimeInMillis());
        }
        catch (ParseException e) {
            throw new DatabindingException("Could not parse xs:dateTime: " + e.getMessage(), (Throwable)e);
        }
    }

    public void writeObject(Object object, MessageWriter writer, Context context) {
        Calendar c = Calendar.getInstance();
        c.setTime((Timestamp)object);
        writer.writeValue(format.format(c));
    }
}

