/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.CaseType;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.ArrayVisitor;
import org.apache.cxf.tools.corba.processors.idl.DeferredActionCollection;
import org.apache.cxf.tools.corba.processors.idl.SchemaDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.ScopeNameCollection;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.TypesVisitor;
import org.apache.cxf.tools.corba.processors.idl.UnionDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaType;

public class UnionVisitor
extends VisitorBase {
    public UnionVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor) {
        super(scope, defn, schemaRef, wsdlVisitor);
    }

    public static boolean accept(AST node) {
        return node.getType() == 55;
    }

    public void visit(AST unionNode) {
        AST identifierNode = unionNode.getFirstChild();
        if (identifierNode.getFirstChild() == null && identifierNode.getNextSibling() == null) {
            this.visitForwardDeclaredUnion(identifierNode);
        } else {
            this.visitDeclaredUnion(identifierNode);
        }
    }

    public void visitDeclaredUnion(AST identifierNode) {
        Scope unionScope = new Scope(this.getScope(), identifierNode);
        AST discriminatorNode = identifierNode.getNextSibling();
        AST caseNode = discriminatorNode.getNextSibling();
        XmlSchemaComplexType unionSchemaComplexType = new XmlSchemaComplexType(this.schema);
        unionSchemaComplexType.setName(this.mapper.mapToQName(unionScope));
        TypesVisitor visitor = new TypesVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor, null);
        visitor.visit(discriminatorNode);
        CorbaTypeImpl ctype = visitor.getCorbaType();
        Scope fullyQualifiedName = visitor.getFullyQualifiedName();
        XmlSchemaChoice choice = new XmlSchemaChoice();
        choice.setMinOccurs(1L);
        choice.setMaxOccurs(1L);
        unionSchemaComplexType.setParticle((XmlSchemaParticle)choice);
        Union corbaUnion = new Union();
        corbaUnion.setQName(new QName(this.typeMap.getTargetNamespace(), unionScope.toString()));
        corbaUnion.setRepositoryID(unionScope.toIDLRepositoryID());
        corbaUnion.setType(unionSchemaComplexType.getQName());
        if (ctype != null) {
            corbaUnion.setDiscriminator(ctype.getQName());
        } else {
            UnionDeferredAction unionDiscriminatorAction = new UnionDeferredAction(corbaUnion);
            this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, unionDiscriminatorAction);
        }
        boolean recursiveAdd = this.addRecursiveScopedName(identifierNode);
        this.processCaseNodes(caseNode, unionScope, choice, corbaUnion);
        if (recursiveAdd) {
            this.removeRecursiveScopedName(identifierNode);
        }
        this.schema.getItems().add((XmlSchemaObject)unionSchemaComplexType);
        this.schema.addType((XmlSchemaType)unionSchemaComplexType);
        this.typeMap.getStructOrExceptionOrUnion().add(corbaUnion);
        this.setSchemaType((XmlSchemaType)unionSchemaComplexType);
        this.setCorbaType(corbaUnion);
        this.processForwardUnionActions(unionScope);
        scopedNames.remove(unionScope);
    }

    private void processCaseNodes(AST caseNode, Scope scope, XmlSchemaChoice choice, Union corbaUnion) {
        while (caseNode != null) {
            AST typeNode = null;
            AST nameNode = null;
            AST labelNode = null;
            XmlSchemaElement element = new XmlSchemaElement();
            Unionbranch unionBranch = new Unionbranch();
            if (caseNode.getType() == 58) {
                unionBranch.setDefault(true);
                typeNode = caseNode.getFirstChild();
                nameNode = typeNode.getNextSibling();
            } else {
                this.createCase(caseNode, unionBranch);
                labelNode = caseNode.getFirstChild();
                if (labelNode.getType() == 57) {
                    labelNode = labelNode.getNextSibling();
                }
                typeNode = labelNode.getNextSibling();
                nameNode = typeNode.getNextSibling();
            }
            TypesVisitor visitor = new TypesVisitor(scope, this.definition, this.schema, this.wsdlVisitor, null);
            visitor.visit(typeNode);
            XmlSchemaType stype = visitor.getSchemaType();
            CorbaTypeImpl ctype = visitor.getCorbaType();
            Scope fullyQualifiedName = visitor.getFullyQualifiedName();
            if (ArrayVisitor.accept(nameNode)) {
                Scope anonScope = new Scope(scope, TypesUtils.getCorbaTypeNameNode(nameNode));
                ArrayVisitor arrayVisitor = new ArrayVisitor(anonScope, this.definition, this.schema, this.wsdlVisitor, null, fullyQualifiedName);
                arrayVisitor.setSchemaType(stype);
                arrayVisitor.setCorbaType(ctype);
                arrayVisitor.visit(nameNode);
                stype = arrayVisitor.getSchemaType();
                ctype = arrayVisitor.getCorbaType();
                fullyQualifiedName = visitor.getFullyQualifiedName();
            }
            element.setName(nameNode.toString());
            if (stype != null) {
                element.setSchemaTypeName(stype.getQName());
                if (stype.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                    element.setNillable(true);
                }
            } else {
                UnionDeferredAction elementAction = new UnionDeferredAction(element);
                this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, elementAction);
            }
            choice.getItems().add((XmlSchemaObject)element);
            unionBranch.setName(nameNode.toString());
            if (ctype != null) {
                unionBranch.setIdltype(ctype.getQName());
            } else {
                UnionDeferredAction unionBranchAction = new UnionDeferredAction(unionBranch);
                this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, unionBranchAction);
            }
            corbaUnion.getUnionbranch().add(unionBranch);
            caseNode = caseNode.getNextSibling();
        }
    }

    private void createCase(AST caseNode, Unionbranch unionBranch) {
        AST node = caseNode.getFirstChild();
        if (node != null) {
            if (node.getType() == 57) {
                CaseType caseType = new CaseType();
                caseType.setLabel(node.getNextSibling().toString());
                unionBranch.getCase().add(caseType);
                this.createCase(node, unionBranch);
            } else {
                CaseType caseType = new CaseType();
                caseType.setLabel(node.toString());
                unionBranch.getCase().add(caseType);
            }
        }
    }

    private void visitForwardDeclaredUnion(AST identifierNode) {
        String unionName = identifierNode.toString();
        Scope unionScope = new Scope(this.getScope(), unionName);
        ScopeNameCollection scopedNames = this.wsdlVisitor.getScopedNames();
        if (scopedNames.getScope(unionScope) == null) {
            scopedNames.add(unionScope);
        }
    }

    private void processForwardUnionActions(Scope unionScope) {
        DeferredActionCollection deferredActions;
        List list;
        if (this.wsdlVisitor.getDeferredActions() != null && (list = (deferredActions = this.wsdlVisitor.getDeferredActions()).getActions(unionScope)) != null && !list.isEmpty()) {
            XmlSchemaType stype = this.getSchemaType();
            CorbaTypeImpl ctype = this.getCorbaType();
            for (SchemaDeferredAction action : list) {
                action.execute(stype, ctype);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    private boolean addRecursiveScopedName(AST identifierNode) {
        String structName = identifierNode.toString();
        Scope structScope = new Scope(this.getScope(), structName);
        ScopeNameCollection scopedNames = this.wsdlVisitor.getScopedNames();
        if (scopedNames.getScope(structScope) == null) {
            scopedNames.add(structScope);
            return true;
        }
        return false;
    }

    private void removeRecursiveScopedName(AST identifierNode) {
        String structName = identifierNode.toString();
        Scope structScope = new Scope(this.getScope(), structName);
        ScopeNameCollection scopedNames = this.wsdlVisitor.getScopedNames();
        scopedNames.remove(structScope);
    }
}

