/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractAttributedInterceptorProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.workqueue.SynchronousExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSServiceImpl
extends AbstractAttributedInterceptorProvider
implements Service,
Configurable {
    private List<ClassResourceInfo> classResourceInfos;
    private DataBinding dataBinding;
    private Executor executor;
    private Invoker invoker;
    private Map<QName, Endpoint> endpoints = new HashMap<QName, Endpoint>();
    private String address;

    public JAXRSServiceImpl() {
    }

    public JAXRSServiceImpl(String address) {
        this.address = address;
    }

    public JAXRSServiceImpl(List<ClassResourceInfo> cri) {
        this.classResourceInfos = cri;
        this.executor = SynchronousExecutor.getInstance();
    }

    @Override
    public String getBeanName() {
        return this.getName().toString();
    }

    @Override
    public QName getName() {
        if (this.address == null) {
            Class<?> primaryClass = this.classResourceInfos.get(0).getServiceClass();
            String ns = PackageUtils.getNamespace(PackageUtils.getPackageName(primaryClass));
            return new QName(ns + "/jaxrs", primaryClass.getSimpleName());
        }
        return new QName(this.address, "WebResource");
    }

    public List<ClassResourceInfo> getClassResourceInfos() {
        return this.classResourceInfos;
    }

    @Override
    public List<ServiceInfo> getServiceInfos() {
        return Collections.emptyList();
    }

    @Override
    public EndpointInfo getEndpointInfo(QName endpoint) {
        return null;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    @Override
    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    @Override
    public Map<QName, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<QName, Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setProperties(Map<String, Object> properties) {
        this.putAll(properties);
    }
}

