/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.attachment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import org.apache.cxf.attachment.LazyDataSource;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBAttachmentUnmarshaller
extends AttachmentUnmarshaller {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBAttachmentUnmarshaller.class);
    private Collection<Attachment> attachments;

    public JAXBAttachmentUnmarshaller(Collection<Attachment> attachments) {
        this.attachments = attachments;
    }

    public DataHandler getAttachmentAsDataHandler(String contentId) {
        return new DataHandler(this.getAttachmentDataSource(contentId));
    }

    public byte[] getAttachmentAsByteArray(String contentId) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            InputStream is = this.getAttachmentDataSource(contentId).getInputStream();
            IOUtils.copy(is, bos);
            is.close();
            bos.close();
        }
        catch (IOException e) {
            throw new Fault(new Message("ATTACHMENT_READ_ERROR", LOG, new Object[0]), (Throwable)e);
        }
        return bos.toByteArray();
    }

    public boolean isXOPPackage() {
        return this.attachments != null;
    }

    private DataSource getAttachmentDataSource(String contentId) {
        if (contentId.startsWith("cid:")) {
            try {
                contentId = URLDecoder.decode(contentId.substring(4), "UTF-8");
            }
            catch (UnsupportedEncodingException ue) {
                contentId = contentId.substring(4);
            }
            return new LazyDataSource(contentId, this.attachments);
        }
        if (contentId.indexOf("://") == -1) {
            return new LazyDataSource(contentId, this.attachments);
        }
        try {
            return new URLDataSource(new URL(contentId));
        }
        catch (MalformedURLException e) {
            throw new Fault(e);
        }
    }
}

