/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.stax.ElementReader;
import org.apache.cxf.aegis.xml.stax.ElementWriter;
import org.apache.cxf.staxutils.FragmentStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;

public class DocumentType
extends Type {
    private DocumentBuilder builder;

    public DocumentType() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DatabindingException("Couldn't load document builder.", (Throwable)e);
        }
        this.setWriteOuter(false);
    }

    public DocumentType(DocumentBuilder builder) {
        this.builder = builder;
        this.setWriteOuter(false);
    }

    public Object readObject(MessageReader mreader, Context context) throws DatabindingException {
        try {
            XMLStreamReader reader = ((ElementReader)mreader).getXMLStreamReader();
            return StaxUtils.read(this.builder, new FragmentStreamReader(reader), true);
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Could not parse xml.", (Throwable)e);
        }
    }

    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        Document doc = (Document)object;
        try {
            StaxUtils.writeElement(doc.getDocumentElement(), ((ElementWriter)writer).getXMLStreamWriter(), false);
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Could not write xml.", (Throwable)e);
        }
    }
}

