/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common;

import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaWriterImpl
extends WSDLWriterImpl {
    public static final int DEFAULT_INDENT_LEVEL = 0;

    public void writeWSDL(Definition wsdlDef, Writer sink) throws WSDLException {
        PrintWriter pw = new PrintWriter(sink);
        String javaEncoding = sink instanceof OutputStreamWriter ? ((OutputStreamWriter)sink).getEncoding() : null;
        String xmlEncoding = DOM2Writer.java2XMLEncoding((String)javaEncoding);
        if (xmlEncoding == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "Unsupported Java encoding for writing schema file: '" + javaEncoding + "'.");
        }
        pw.println("<?xml version=\"1.0\" encoding=\"" + xmlEncoding + "\"?>");
        this.printSchema(wsdlDef, pw);
    }

    protected void printSchema(Definition def, PrintWriter pw) throws WSDLException {
        if (def == null) {
            return;
        }
        Types types = def.getTypes();
        if (types != null) {
            List extElements = types.getExtensibilityElements();
            this.printExtensibilityElements(Types.class, extElements, def, pw);
        }
        pw.flush();
    }

    public void printExtensibilityElements(Class class1, List list, Definition def, PrintWriter pw) throws WSDLException {
        if (list != null) {
            for (ExtensibilityElement extElement : list) {
                if (extElement instanceof Schema) {
                    this.printDOMElement(((Schema)extElement).getElement(), pw, 0);
                    pw.println();
                    continue;
                }
                super.printExtensibilityElements(class1, list, def, pw);
            }
        }
    }

    private void printDOMElement(Element element, PrintWriter pw, int indentCount) {
        this.indent(pw, indentCount);
        if (element.getLocalName().equals("schema")) {
            pw.print("<xs:" + element.getLocalName());
        } else {
            pw.print("<" + element.getNodeName());
        }
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            pw.print(" " + attr.getName() + "=\"" + attr.getValue() + "\"");
        }
        pw.print(">");
        NodeList list = element.getChildNodes();
        pw.println();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.printDOMElement((Element)node, pw, indentCount + 2);
            pw.println();
        }
        this.indent(pw, indentCount);
        if (element.getLocalName().equals("schema")) {
            pw.print("</xs:" + element.getLocalName() + ">");
        } else {
            pw.print("</" + element.getNodeName() + ">");
        }
    }

    public void indent(PrintWriter pw, int count) {
        for (int i = 0; i < count; ++i) {
            pw.print(' ');
        }
    }
}

