/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.Wrapper;
import org.apache.cxf.tools.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestWrapper
extends Wrapper {
    @Override
    public void setOperationInfo(OperationInfo op) {
        super.setOperationInfo(op);
        this.setName(op.getInput().getMessageParts().get(0).getElementQName());
        this.setClassName((String)op.getInput().getMessageParts().get(0).getProperty("REQUEST.WRAPPER.CLASSNAME"));
    }

    @Override
    public boolean isWrapperAbsent(Method method) {
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        return this.getClassName() == null && (reqWrapper == null || StringUtils.isEmpty(reqWrapper.className()));
    }

    public String getWrapperTns(Method method) {
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        if (reqWrapper != null) {
            return reqWrapper.targetNamespace();
        }
        return null;
    }

    @Override
    protected List<JavaField> buildFields() {
        return this.buildFields(this.getMethod(), this.getOperationInfo().getUnwrappedOperation().getInput());
    }

    protected List<JavaField> buildFields(Method method, MessageInfo message) {
        ArrayList<JavaField> fields = new ArrayList<JavaField>();
        Class<?>[] paramClasses = method.getParameterTypes();
        for (MessagePartInfo mpi : message.getMessageParts()) {
            int idx = mpi.getIndex();
            String name = mpi.getName().getLocalPart();
            Class<?> clz = paramClasses[idx];
            String type = clz.isArray() ? (this.isBuiltInTypes(clz.getComponentType()) ? clz.getComponentType().getSimpleName() + "[]" : clz.getComponentType().getName() + "[]") : clz.getName();
            JavaField field = new JavaField(name, type, "");
            field.setTargetNamespace("");
            fields.add(field);
        }
        return fields;
    }

    @Override
    public WrapperBeanClass getWrapperBeanClass(Method method) {
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        String reqClassName = this.getClassName();
        String reqNs = null;
        if (reqWrapper != null) {
            reqClassName = reqWrapper.className().length() > 0 ? reqWrapper.className() : reqClassName;
            String string = reqNs = reqWrapper.targetNamespace().length() > 0 ? reqWrapper.targetNamespace() : null;
        }
        if (reqClassName == null) {
            reqClassName = this.getPackageName(method) + ".jaxws." + AnnotationUtil.capitalize(method.getName());
        }
        WrapperBeanClass jClass = new WrapperBeanClass();
        jClass.setFullClassName(reqClassName);
        jClass.setNamespace(reqNs);
        return jClass;
    }
}

