/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolContainer;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.core.FrontEndProfile;
import org.apache.cxf.tools.wsdlto.core.PluginLoader;

public class WSDLToJava {
    public static final String DEFAULT_FRONTEND_NAME = "jaxws";
    public static final String DEFAULT_DATABINDING_NAME = "jaxb";
    private String[] args;
    private PluginLoader pluginLoader = PluginLoader.getInstance();

    public WSDLToJava() {
        this.args = new String[0];
    }

    public WSDLToJava(String[] pargs) {
        this.args = pargs;
    }

    private FrontEndProfile loadFrontEnd(String name) {
        if (StringUtils.isEmpty(name)) {
            name = DEFAULT_FRONTEND_NAME;
        }
        if (this.isVerbose()) {
            System.out.println("Loading FrontEnd " + name + " ...");
        }
        return this.pluginLoader.getFrontEndProfile(name);
    }

    private DataBindingProfile loadDataBinding(String name) {
        if (StringUtils.isEmpty(name)) {
            name = DEFAULT_DATABINDING_NAME;
        }
        if (this.isVerbose()) {
            System.out.println("Loading DataBinding " + name + " ...");
        }
        return this.pluginLoader.getDataBindingProfile(name);
    }

    private boolean isExitOnFinish() {
        String exit = System.getProperty("exitOnFinish");
        if (StringUtils.isEmpty(exit)) {
            return false;
        }
        return "YES".equalsIgnoreCase(exit) || "TRUE".equalsIgnoreCase(exit);
    }

    public void run(ToolContext context) throws Exception {
        FrontEndProfile frontend = null;
        if (this.args != null) {
            context.put("args", this.args);
            frontend = this.loadFrontEnd(this.getFrontEndName(this.args));
        } else {
            frontend = this.loadFrontEnd("");
        }
        context.put(FrontEndProfile.class, frontend);
        DataBindingProfile databinding = this.loadDataBinding(this.getDataBindingName(this.args));
        context.put(DataBindingProfile.class, databinding);
        Class<? extends ToolContainer> containerClass = frontend.getContainerClass();
        InputStream toolspecStream = WSDLToJava.getResourceAsStream(containerClass, frontend.getToolspec());
        ToolRunner.runTool(containerClass, toolspecStream, false, this.args, this.isExitOnFinish(), context);
    }

    protected boolean isVerbose() {
        return this.isSet(new String[]{"-V", "-verbose"});
    }

    private boolean isSet(String[] keys) {
        if (this.args == null) {
            return false;
        }
        List<String> pargs = Arrays.asList(this.args);
        for (String key : keys) {
            if (!pargs.contains(key)) continue;
            return true;
        }
        return false;
    }

    private String parseArguments(String[] pargs, String key) {
        if (pargs == null) {
            return null;
        }
        List<String> largs = Arrays.asList(pargs);
        int index = 0;
        if (largs.contains(key) && (index = largs.indexOf(key)) + 1 < largs.size()) {
            return largs.get(index + 1);
        }
        return null;
    }

    private String getOptionValue(String[] pargs, String[] keys) {
        for (String key : keys) {
            String value = this.parseArguments(pargs, key);
            if (StringUtils.isEmpty(value)) continue;
            return value.trim();
        }
        return null;
    }

    protected String getFrontEndName(String[] pargs) {
        return this.getOptionValue(pargs, new String[]{"-frontend", "-fe"});
    }

    protected String getDataBindingName(String[] pargs) {
        return this.getOptionValue(pargs, new String[]{"-databinding", "-db"});
    }

    public void setArguments(String[] pargs) {
        this.args = pargs;
    }

    public static void main(String[] pargs) {
        WSDLToJava w2j;
        block7: {
            w2j = new WSDLToJava(pargs);
            try {
                w2j.run(new ToolContext());
            }
            catch (ToolException ex) {
                System.err.println();
                System.err.println("WSDLToJava Error: " + ex.getMessage());
                System.err.println();
                if (w2j.isVerbose()) {
                    ex.printStackTrace();
                }
                if (w2j.isExitOnFinish()) {
                    System.exit(1);
                }
            }
            catch (Exception ex) {
                System.err.println("WSDLToJava Error: " + ex.getMessage());
                System.err.println();
                if (w2j.isVerbose()) {
                    ex.printStackTrace();
                }
                if (!w2j.isExitOnFinish()) break block7;
                System.exit(1);
            }
        }
        if (w2j.isExitOnFinish()) {
            System.exit(0);
        }
    }

    private static InputStream getResourceAsStream(Class clz, String file) {
        return clz.getResourceAsStream(file);
    }
}

